/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth;

import org.cloudfoundry.identity.uaa.oauth.HmacKeyInfo;
import org.cloudfoundry.identity.uaa.oauth.KeyInfo;
import org.cloudfoundry.identity.uaa.oauth.RsaKeyInfo;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyInfoBuilder {
    public static KeyInfo build(String keyId, String signingKey, String uaaUrl) {
        if (StringUtils.isEmpty((Object)signingKey)) {
            throw new IllegalArgumentException("Signing key cannot be empty");
        }
        Assert.hasText((String)signingKey, (String)"[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
        signingKey = signingKey.trim();
        if (KeyInfoBuilder.isAssymetricKey(signingKey)) {
            return new RsaKeyInfo(keyId, signingKey, uaaUrl);
        }
        return new HmacKeyInfo(keyId, signingKey, uaaUrl);
    }

    private static boolean isAssymetricKey(String key) {
        return key.startsWith("-----BEGIN");
    }
}

