/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.message;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.message.MessageService;
import org.cloudfoundry.identity.uaa.message.MessageType;
import org.cloudfoundry.identity.uaa.zone.MergedZoneBrandingInformation;
import org.cloudfoundry.identity.uaa.zone.beans.IdentityZoneManager;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class EmailService
implements MessageService {
    private final Log logger = LogFactory.getLog(this.getClass());
    private JavaMailSender mailSender;
    private final String fromAddress;
    private final IdentityZoneManager identityZoneManager;

    public EmailService(JavaMailSender mailSender, String loginUrl, String fromAddress, IdentityZoneManager identityZoneManager) {
        this.mailSender = mailSender;
        this.identityZoneManager = identityZoneManager;
        if (fromAddress != null && !fromAddress.isEmpty()) {
            this.fromAddress = fromAddress;
        } else {
            String host = UriComponentsBuilder.fromHttpUrl((String)loginUrl).build().getHost();
            this.fromAddress = "admin@" + host;
        }
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    private Address[] getSenderAddresses() throws UnsupportedEncodingException {
        String companyName;
        String name = this.identityZoneManager.isCurrentZoneUaa() ? (StringUtils.hasText((String)(companyName = MergedZoneBrandingInformation.resolveBranding().getCompanyName())) ? companyName : "Cloud Foundry") : this.identityZoneManager.getCurrentIdentityZone().getName();
        return new Address[]{new InternetAddress(this.fromAddress, name)};
    }

    @Override
    public void sendMessage(String email, MessageType messageType, String subject, String htmlContent) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            message.addFrom(this.getSenderAddresses());
            message.addRecipients(Message.RecipientType.TO, email);
            message.setSubject(subject);
            message.setContent((Object)htmlContent, "text/html");
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            this.logger.error((Object)("Exception raised while sending message to " + email), e);
        }
        this.mailSender.send(message);
    }
}

