/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.provider.ldap.ExtendedLdapUserMapper;
import org.cloudfoundry.identity.uaa.provider.ldap.ProcessLdapProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class LdapIntegrationConfig {
    @Bean
    public ProcessLdapProperties ldapPropertyProcessor(Environment environment) {
        boolean skipSslVerification = Boolean.parseBoolean(environment.getProperty("ldap.ssl.skipverification"));
        String baseUrl = Optional.ofNullable(environment.getProperty("ldap.base.url")).orElse("ldap://localhost:389/dc=test,dc=com");
        String tlsConfig = Optional.ofNullable(environment.getProperty("ldap.ssl.tls")).orElse("none");
        return new ProcessLdapProperties(baseUrl, skipSslVerification, tlsConfig);
    }

    @Bean
    public Map ldapProperties(Environment environment) throws NoSuchAlgorithmException, KeyManagementException {
        HashMap<String, Object> initialLdapProperties = new HashMap<String, Object>();
        initialLdapProperties.put("com.sun.jndi.ldap.connect.pool", false);
        initialLdapProperties.put("java.naming.referral", Optional.ofNullable(environment.getProperty("ldap.base.referral")).orElse("follow"));
        return this.ldapPropertyProcessor(environment).process(initialLdapProperties);
    }

    @Bean
    public ExtendedLdapUserMapper extendedLdapUserDetailsMapper(Environment environment) {
        String mailAttributeName = Optional.ofNullable(environment.getProperty("ldap.base.mailAttributeName")).orElse("mail");
        String givenNameAttributeName = Optional.ofNullable(environment.getProperty("ldap.attributeMappings.first_name")).orElse("givenname");
        String familyNameAttributeName = Optional.ofNullable(environment.getProperty("ldap.attributeMappings.family_name")).orElse("sn");
        String phoneNumberAttributeName = Optional.ofNullable(environment.getProperty("ldap.attributeMappings.phone_number")).orElse("telephonenumber");
        String verifiedAttributeName = Optional.ofNullable(environment.getProperty("ldap.attributeMappings.email_verified")).orElse("email_verified");
        String mailSubstitute = environment.getProperty("ldap.base.mailSubstitute");
        boolean mailSubstituteOverridesLdap = Boolean.parseBoolean(environment.getProperty("ldap.base.mailSubstituteOverridesLdap"));
        ExtendedLdapUserMapper extendedLdapUserDetailsMapper = new ExtendedLdapUserMapper();
        extendedLdapUserDetailsMapper.setEmailVerifiedAttributeName(verifiedAttributeName);
        extendedLdapUserDetailsMapper.setMailAttributeName(mailAttributeName);
        extendedLdapUserDetailsMapper.setGivenNameAttributeName(givenNameAttributeName);
        extendedLdapUserDetailsMapper.setFamilyNameAttributeName(familyNameAttributeName);
        extendedLdapUserDetailsMapper.setPhoneNumberAttributeName(phoneNumberAttributeName);
        extendedLdapUserDetailsMapper.setMailSubstitute(mailSubstitute);
        extendedLdapUserDetailsMapper.setMailSubstituteOverridesLdap(mailSubstituteOverridesLdap);
        return extendedLdapUserDetailsMapper;
    }
}

