/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.impl.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EnvironmentMapFactoryBean
implements FactoryBean<Map<String, ?>>,
EnvironmentAware {
    private static Log logger = LogFactory.getLog(EnvironmentMapFactoryBean.class);
    private static final Collection<String> STATIC_PROPERTY_SOURCES = Arrays.asList("systemProperties", "systemEnvironment");
    private Environment environment;
    private Map<String, ?> defaultProperties = new HashMap();

    public void setDefaultProperties(Map<String, ?> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Map<String, ?> getObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Iterator iterator = this.defaultProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String name = key = iterator.next();
            if (this.environment != null && this.environment.containsProperty(name)) {
                Object value = this.environment.getProperty(name, Object.class);
                logger.debug((Object)("From Environment: " + name));
                result.put(name, value);
                continue;
            }
            logger.debug((Object)("From Defaults: " + name));
            result.put(name, this.defaultProperties.get(key));
        }
        if (this.environment instanceof ConfigurableEnvironment) {
            for (PropertySource source : ((ConfigurableEnvironment)this.environment).getPropertySources()) {
                if (!(source instanceof EnumerablePropertySource) || STATIC_PROPERTY_SOURCES.contains(source.getName())) continue;
                EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
                for (String name : enumerable.getPropertyNames()) {
                    Object value = source.getProperty(name);
                    if (value instanceof String) {
                        value = this.environment.resolvePlaceholders((String)value);
                    }
                    result.put(name, value);
                }
            }
        }
        return result;
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

