/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.client;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.cloudfoundry.identity.uaa.zone.ZoneManagementScopes;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UaaScopes {
    private Set<Pattern> regExPatterns = UaaStringUtils.constructWildcards(new HashSet(ZoneManagementScopes.UAA_SCOPES));

    public List<String> getUaaScopes() {
        return ZoneManagementScopes.UAA_SCOPES;
    }

    public List<GrantedAuthority> getUaaAuthorities() {
        LinkedList<GrantedAuthority> result = new LinkedList<GrantedAuthority>();
        for (String s : this.getUaaScopes()) {
            result.add((GrantedAuthority)new SimpleGrantedAuthority(s));
        }
        return result;
    }

    public boolean isWildcardScope(String scope) {
        return UaaStringUtils.containsWildcard((String)scope);
    }

    public boolean isWildcardScope(GrantedAuthority authority) {
        return this.isWildcardScope(authority.getAuthority());
    }

    public boolean isUaaScope(String scope) {
        return UaaStringUtils.matches(this.regExPatterns, (String)scope);
    }

    public boolean isUaaScope(GrantedAuthority authority) {
        return this.isUaaScope(authority.getAuthority());
    }
}

