/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InsufficientScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class ScopeAuthenticationManager
implements AuthenticationManager {
    private boolean throwOnNotAuthenticated = true;
    private List<String> requiredScopes;

    public List<String> getRequiredScopes() {
        return this.requiredScopes;
    }

    public void setRequiredScopes(List<String> requiredScopes) {
        this.requiredScopes = this.dedup(requiredScopes);
    }

    public boolean isThrowOnNotAuthenticated() {
        return this.throwOnNotAuthenticated;
    }

    public void setThrowOnNotAuthenticated(boolean throwOnNotAuthenticated) {
        this.throwOnNotAuthenticated = throwOnNotAuthenticated;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Request creq = ((OAuth2Authentication)authentication).getOAuth2Request();
            List<String> scopes = this.dedup(creq.getScope());
            int matches = 0;
            int requiredMatches = this.getRequiredScopes().size();
            for (String scope : scopes) {
                if (!this.requiredScopes.contains(scope)) continue;
                ++matches;
            }
            if (matches == requiredMatches) {
                authentication.setAuthenticated(true);
                return authentication;
            }
            if (this.isThrowOnNotAuthenticated()) {
                throw new InsufficientScopeException("Insufficient scopes");
            }
        } else if (this.isThrowOnNotAuthenticated()) {
            throw new InvalidTokenException("Missing Oauth 2 authentication.");
        }
        return authentication;
    }

    public List<String> dedup(Collection<String> list) {
        ArrayList<String> deduped = new ArrayList<String>(new LinkedHashSet<String>(list));
        return deduped;
    }
}

