/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.AccountNotVerifiedException;
import org.cloudfoundry.identity.uaa.authentication.AuthzAuthenticationRequest;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.login.AuthenticationResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RemoteAuthenticationEndpoint {
    private final Log logger = LogFactory.getLog(this.getClass());
    private AuthenticationManager authenticationManager;
    private AuthenticationManager loginAuthenticationManager;

    public void setLoginAuthenticationManager(AuthenticationManager loginAuthenticationManager) {
        this.loginAuthenticationManager = loginAuthenticationManager;
    }

    public RemoteAuthenticationEndpoint(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @RequestMapping(value={"/authenticate"}, method={RequestMethod.POST})
    @ResponseBody
    public HttpEntity<AuthenticationResponse> authenticate(HttpServletRequest request, @RequestParam(value="username", required=true) String username, @RequestParam(value="password", required=true) String password) {
        AuthenticationResponse response = new AuthenticationResponse();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        token.setDetails((Object)new UaaAuthenticationDetails(request));
        HttpStatus status = HttpStatus.UNAUTHORIZED;
        try {
            Authentication a = this.authenticationManager.authenticate((Authentication)token);
            response.setUsername(a.getName());
            if (a.getPrincipal() != null && a.getPrincipal() instanceof UaaPrincipal) {
                response.setEmail(((UaaPrincipal)a.getPrincipal()).getEmail());
            }
            this.processAdditionalInformation(response, a);
            status = HttpStatus.OK;
        }
        catch (AccountNotVerifiedException e) {
            response.setError("account not verified");
            status = HttpStatus.FORBIDDEN;
        }
        catch (AuthenticationException e) {
            response.setError("authentication failed");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Failed to authenticate user ", (Throwable)e);
            response.setError("error");
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return new ResponseEntity((Object)response, status);
    }

    @RequestMapping(value={"/authenticate"}, method={RequestMethod.POST}, params={"source", "origin", "add_new"})
    @ResponseBody
    public HttpEntity<AuthenticationResponse> authenticate(HttpServletRequest request, @RequestParam(value="username", required=true) String username, @RequestParam(value="origin", required=true) String origin, @RequestParam(value="email", required=false) String email) {
        AuthenticationResponse response = new AuthenticationResponse();
        HttpStatus status = HttpStatus.UNAUTHORIZED;
        if (!this.hasClientOauth2Authentication()) {
            response.setError("authentication failed");
            return new ResponseEntity((Object)response, status);
        }
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("username", username);
        userInfo.put("origin", origin);
        if (StringUtils.hasText((String)email)) {
            userInfo.put("email", email);
        }
        AuthzAuthenticationRequest token = new AuthzAuthenticationRequest(userInfo, new UaaAuthenticationDetails(request));
        try {
            Authentication a = this.loginAuthenticationManager.authenticate((Authentication)token);
            response.setUsername(a.getName());
            this.processAdditionalInformation(response, a);
            status = HttpStatus.OK;
        }
        catch (AuthenticationException e) {
            response.setError("authentication failed");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Failed to authenticate user ", (Throwable)e);
            response.setError("error");
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return new ResponseEntity((Object)response, status);
    }

    private void processAdditionalInformation(AuthenticationResponse response, Authentication a) {
        UaaPrincipal principal;
        if (this.hasClientOauth2Authentication() && (principal = this.getPrincipal(a)) != null) {
            response.setOrigin(principal.getOrigin());
            response.setUserId(principal.getId());
        }
    }

    protected UaaPrincipal getPrincipal(Authentication a) {
        if (a.getPrincipal() instanceof UaaPrincipal) {
            return (UaaPrincipal)a.getPrincipal();
        }
        return null;
    }

    protected boolean hasClientOauth2Authentication() {
        OAuth2Authentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        return context.getAuthentication() instanceof OAuth2Authentication && (authentication = (OAuth2Authentication)context.getAuthentication()).isClientOnly();
    }
}

