/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.audit.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.security.Principal;
import java.util.Map;
import org.cloudfoundry.identity.uaa.audit.AuditEvent;
import org.cloudfoundry.identity.uaa.audit.AuditEventType;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.oauth.jwt.Jwt;
import org.cloudfoundry.identity.uaa.oauth.jwt.JwtHelper;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class TokenIssuedEvent
extends AbstractUaaEvent {
    public TokenIssuedEvent(OAuth2AccessToken source, Authentication principal) {
        super(source, principal);
        if (!OAuth2AccessToken.class.isAssignableFrom(source.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    public OAuth2AccessToken getSource() {
        return (OAuth2AccessToken)super.getSource();
    }

    @Override
    public AuditEvent getAuditEvent() {
        String data = JsonUtils.writeValueAsString((Object)this.getSource().getScope());
        return this.createAuditRecord(this.getPrincipalId(), AuditEventType.TokenIssuedEvent, this.getOrigin((Principal)this.getAuthentication()), data);
    }

    private String getPrincipalId() {
        OAuth2AccessToken token = this.getSource();
        Jwt jwt = JwtHelper.decode(token.getValue());
        Map claims = (Map)JsonUtils.readValue((String)jwt.getClaims(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (claims.get("user_id") != null ? claims.get("user_id") : claims.get("client_id")).toString();
    }
}

