/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.approval.ApprovalStore;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.cloudfoundry.identity.uaa.util.UaaTokenUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class ApprovalService {
    TimeService timeService;
    ApprovalStore approvalStore;
    private final Log logger = LogFactory.getLog(this.getClass());

    public ApprovalService(TimeService timeService, ApprovalStore approvalStore) {
        this.timeService = timeService;
        this.approvalStore = approvalStore;
    }

    public void ensureRequiredApprovals(String userId, Collection<String> requestedScopes, String grantType, BaseClientDetails clientDetails) {
        Set<String> autoApprovedScopes = this.getAutoApprovedScopes(grantType, requestedScopes, clientDetails.getAutoApproveScopes());
        if (autoApprovedScopes.containsAll(requestedScopes)) {
            return;
        }
        HashSet<String> approvedScopes = new HashSet<String>(autoApprovedScopes);
        List<Approval> approvals = this.approvalStore.getApprovals(userId, clientDetails.getClientId(), IdentityZoneHolder.get().getId());
        for (Approval approval : approvals) {
            if (!requestedScopes.contains(approval.getScope()) || approval.getStatus() != Approval.ApprovalStatus.APPROVED) continue;
            if (!approval.isActiveAsOf(this.timeService.getCurrentDate())) {
                this.logger.debug((Object)("Approval " + approval + " has expired. Need to re-approve."));
                throw new InvalidTokenException("Invalid token (approvals expired)");
            }
            approvedScopes.add(approval.getScope());
        }
        if (!approvedScopes.containsAll(requestedScopes)) {
            this.logger.debug((Object)("All requested scopes " + requestedScopes + " were not approved. Approved scopes: " + approvedScopes));
            HashSet<String> unapprovedScopes = new HashSet<String>(requestedScopes);
            unapprovedScopes.removeAll(approvedScopes);
            throw new InvalidTokenException("Invalid token (some requested scopes are not approved): " + unapprovedScopes);
        }
    }

    private Set<String> getAutoApprovedScopes(Object grantType, Collection<String> tokenScopes, Set<String> autoapprovedScopes) {
        if (grantType != null && "password".equals(grantType.toString())) {
            return new HashSet<String>(tokenScopes);
        }
        return UaaTokenUtils.retainAutoApprovedScopes(tokenScopes, autoapprovedScopes);
    }
}

