/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account.event;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.account.event.PasswordChangeEvent;
import org.cloudfoundry.identity.uaa.account.event.PasswordChangeFailureEvent;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.authentication.SystemAuthentication;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class PasswordChangeEventPublisher
implements ApplicationEventPublisherAware {
    private ScimUserProvisioning dao;
    private ApplicationEventPublisher publisher;

    public PasswordChangeEventPublisher(ScimUserProvisioning provisioning) {
        this.dao = provisioning;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void passwordFailure(String userId, Exception e) {
        UaaUser user = this.getUser(userId);
        this.publish(new PasswordChangeFailureEvent(e.getMessage(), user, this.getPrincipal()));
    }

    public void passwordChange(String userId) {
        this.publish(new PasswordChangeEvent("Password changed", this.getUser(userId), this.getPrincipal()));
    }

    private UaaUser getUser(String userId) {
        try {
            ScimUser scimUser = (ScimUser)this.dao.retrieve(userId, IdentityZoneHolder.get().getId());
            Date today = new Date();
            if (scimUser != null) {
                return new UaaUser(scimUser.getId(), scimUser.getUserName(), "N/A", this.getEmail(scimUser), null, scimUser.getGivenName(), scimUser.getFamilyName(), today, today, scimUser.getOrigin(), scimUser.getExternalId(), scimUser.isVerified(), scimUser.getZoneId(), scimUser.getSalt(), scimUser.getPasswordLastModified());
            }
        }
        catch (ScimResourceNotFoundException scimResourceNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private String getEmail(ScimUser scimUser) {
        List emails = scimUser.getEmails();
        if (emails == null || emails.isEmpty()) {
            return scimUser.getUserName().contains("@") ? scimUser.getUserName() : scimUser.getUserName() + "@unknown.org";
        }
        for (ScimUser.Email email : emails) {
            if (!email.isPrimary()) continue;
            return email.getValue();
        }
        return ((ScimUser.Email)scimUser.getEmails().get(0)).getValue();
    }

    protected Authentication getPrincipal() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).orElse(SystemAuthentication.SYSTEM_AUTHENTICATION);
    }

    private void publish(AbstractUaaEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)event);
        }
    }
}

