/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.cloudfoundry.identity.uaa.authentication.GenericPasswordPolicy;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientSecretPolicy
extends GenericPasswordPolicy<ClientSecretPolicy> {
    public static final String CLIENT_SECRET_POLICY_FIELD = "clientSecretPolicy";
    @JsonIgnore
    private int expireSecretInMonths;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.expireSecretInMonths;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSecretPolicy that = (ClientSecretPolicy)obj;
        return super.equals(obj) && this.expireSecretInMonths == that.expireSecretInMonths;
    }

    public ClientSecretPolicy() {
        this.expireSecretInMonths = -1;
    }

    public ClientSecretPolicy(int minLength, int maxLength, int requireUpperCaseCharacter, int requireLowerCaseCharacter, int requireDigit, int requireSpecialCharacter, int expireSecretInMonths) {
        super(minLength, maxLength, requireUpperCaseCharacter, requireLowerCaseCharacter, requireDigit, requireSpecialCharacter);
        this.setExpireSecretInMonths(expireSecretInMonths);
    }

    public int getExpireSecretInMonths() {
        return this.expireSecretInMonths;
    }

    public ClientSecretPolicy setExpireSecretInMonths(int expireSecretInMonths) {
        this.expireSecretInMonths = expireSecretInMonths;
        return this;
    }

    @Override
    public boolean allPresentAndPositive() {
        return super.allPresentAndPositive() && this.expireSecretInMonths >= 0;
    }
}

