/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

public class UaaStringUtils {
    public static final String ZONE_VAR_ID = "{zone.id}";
    public static final String ZONE_VAR_SUBDOMAIN = "{zone.subdomain}";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";

    public static String replaceZoneVariables(String s, IdentityZone zone) {
        return s.replace(ZONE_VAR_ID, zone.getId()).replace(ZONE_VAR_SUBDOMAIN, zone.getSubdomain());
    }

    public static String nonNull(String ... s) {
        if (s != null) {
            for (String str : s) {
                if (str == null) continue;
                return str;
            }
        }
        return null;
    }

    public static String camelToUnderscore(String value) {
        String result = value.replace(" ", "_");
        result = result.replaceAll("([a-z])([A-Z])", "$1_$2");
        result = result.replace(".", "_");
        result = result.toLowerCase();
        return result;
    }

    public static String getErrorName(Exception e) {
        String name = e.getClass().getSimpleName();
        if ((name = UaaStringUtils.camelToUnderscore(name)).endsWith("_exception")) {
            name = name.substring(0, name.lastIndexOf("_exception"));
        }
        return name;
    }

    public static Map<String, ?> hidePasswords(Map<String, ?> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.putAll(map);
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof String) {
                if (!UaaStringUtils.isPassword(key)) continue;
                result.put(key, "#");
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map bare = (Map)value;
            result.put(key, UaaStringUtils.hidePasswords(bare));
        }
        return result;
    }

    public static Properties hidePasswords(Properties properties) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)properties);
        for (String key : properties.stringPropertyNames()) {
            if (!UaaStringUtils.isPassword(key)) continue;
            result.put(key, "#");
        }
        return result;
    }

    public static Set<String> retainAllMatches(Collection<String> values, Collection<String> whitelist) {
        Set<Pattern> regExPatterns = UaaStringUtils.constructWildcards(new HashSet<String>(whitelist), UaaStringUtils::constructSimpleWildcardPatternWithAnyCharDelimiter);
        return values.stream().filter(s -> UaaStringUtils.matches(regExPatterns, s)).collect(Collectors.toSet());
    }

    public static boolean containsWildcard(String s) {
        if (StringUtils.hasText((String)s)) {
            return !UaaStringUtils.escapeRegExCharacters(s).equals(UaaStringUtils.constructSimpleWildcardPattern(s));
        }
        return false;
    }

    public static String escapeRegExCharacters(String s) {
        return UaaStringUtils.escapeRegExCharacters(s, "([^a-zA-Z0-9 ])");
    }

    public static String escapeRegExCharacters(String s, String pattern) {
        return s.replaceAll(pattern, "\\\\$1");
    }

    public static String constructSimpleWildcardPattern(String s) {
        String result = UaaStringUtils.escapeRegExCharacters(s);
        return result.replace("\\*", "[^\\\\.]+");
    }

    public static String constructSimpleWildcardPatternWithAnyCharDelimiter(String s) {
        String result = UaaStringUtils.escapeRegExCharacters(s);
        return result.replace("\\*", ".*");
    }

    public static Set<Pattern> constructWildcards(Collection<String> wildcardStrings) {
        return UaaStringUtils.constructWildcards(wildcardStrings, UaaStringUtils::constructSimpleWildcardPattern);
    }

    public static Set<Pattern> constructWildcards(Collection<String> wildcardStrings, Function<String, String> replace) {
        HashSet<Pattern> wildcards = new HashSet<Pattern>();
        for (String wildcard : wildcardStrings) {
            String pattern = replace.apply(wildcard);
            wildcards.add(Pattern.compile(pattern));
        }
        return wildcards;
    }

    public static boolean matches(Set<Pattern> wildcards, String scope) {
        for (Pattern wildcard : wildcards) {
            if (!wildcard.matcher(scope).matches()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, ?> getMapFromProperties(Properties properties, String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            result.put(name, properties.getProperty(key));
        }
        return result;
    }

    public static String getHostIfArgIsURL(String arg) {
        try {
            URL uri = new URL(arg);
            return uri.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return arg;
        }
    }

    private static boolean isPassword(String key) {
        return (key = key.toLowerCase()).endsWith("password") || key.endsWith("secret") || key.endsWith("signing-key") || key.contains("serviceproviderkey");
    }

    public static Set<String> getStringsFromAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            result.add(grantedAuthority.getAuthority());
        }
        return result;
    }

    public static List<? extends GrantedAuthority> getAuthoritiesFromStrings(Collection<String> authorities) {
        if (authorities == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SimpleGrantedAuthority> result = new LinkedList<SimpleGrantedAuthority>();
        for (String s : authorities) {
            result.add(new SimpleGrantedAuthority(s));
        }
        return result;
    }

    public static boolean containsIgnoreCase(List<String> list, String findMe) {
        for (String s : list) {
            if (!findMe.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static String convertISO8859_1_to_UTF_8(String s) {
        if (s == null) {
            return null;
        }
        return new String(s.getBytes(Charset.forName(ISO_8859_1)), Charset.forName(UTF_8));
    }

    public static String toJsonString(String s) {
        if (s == null) {
            return null;
        }
        String result = JsonUtils.writeValueAsString((Object)s);
        return result.substring(1, result.length() - 1);
    }
}

