/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimUser;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScimGroupMember<TEntity extends ScimCore> {
    @JsonProperty(value="value")
    private String memberId;
    private String origin = "uaa";
    private String operation;
    private Type type;
    private TEntity entity;

    public TEntity getEntity() {
        return this.entity;
    }

    public void setEntity(TEntity entity) {
        this.entity = entity;
    }

    public ScimGroupMember() {
    }

    public ScimGroupMember(String memberId) {
        this(memberId, Type.USER);
    }

    public ScimGroupMember(TEntity entity) {
        this(((ScimCore)entity).getId(), ScimGroupMember.getEntityType(entity));
        this.setEntity(entity);
    }

    public ScimGroupMember(String memberId, Type type) {
        this.memberId = memberId;
        this.type = type;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String toString() {
        return String.format("(memberId: %s, type: %s, origin:%s)", new Object[]{this.getMemberId(), this.getType(), this.getOrigin()});
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroupMember member = (ScimGroupMember)o;
        if (this.getMemberId() != null ? !this.getMemberId().equals(member.getMemberId()) : member.getMemberId() != null) {
            return false;
        }
        return this.getType() == member.getType();
    }

    public int hashCode() {
        int result = this.getMemberId() != null ? this.getMemberId().hashCode() : 0;
        result = 31 * result + (this.getOrigin() != null ? this.getOrigin().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    private static Type getEntityType(ScimCore entity) {
        Type type = null;
        if (entity instanceof ScimGroup) {
            type = Type.GROUP;
        } else if (entity instanceof ScimUser) {
            type = Type.USER;
        }
        return type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static enum Type {
        USER,
        GROUP;

    }
}

