/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.provider.ExternalIdentityProviderDefinition;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LdapIdentityProviderDefinition
extends ExternalIdentityProviderDefinition {
    public static final String LDAP_TLS_NONE = "none";
    public static final String LDAP_TLS_SIMPLE = "simple";
    public static final String LDAP_TLS_EXTERNAL = "external";
    public static final String LDAP = "ldap";
    public static final String LDAP_PREFIX = "ldap.";
    public static final String LDAP_ATTRIBUTE_MAPPINGS = "ldap.attributeMappings";
    public static final String LDAP_BASE_LOCAL_PASSWORD_COMPARE = "ldap.base.localPasswordCompare";
    public static final String LDAP_BASE_MAIL_ATTRIBUTE_NAME = "ldap.base.mailAttributeName";
    public static final String LDAP_BASE_MAIL_SUBSTITUTE = "ldap.base.mailSubstitute";
    public static final String LDAP_BASE_MAIL_SUBSTITUTE_OVERRIDES_LDAP = "ldap.base.mailSubstituteOverridesLdap";
    public static final String LDAP_BASE_PASSWORD = "ldap.base.password";
    public static final String LDAP_BASE_PASSWORD_ATTRIBUTE_NAME = "ldap.base.passwordAttributeName";
    public static final String LDAP_BASE_PASSWORD_ENCODER = "ldap.base.passwordEncoder";
    public static final String LDAP_BASE_REFERRAL = "ldap.base.referral";
    public static final String LDAP_BASE_SEARCH_BASE = "ldap.base.searchBase";
    public static final String LDAP_BASE_SEARCH_FILTER = "ldap.base.searchFilter";
    public static final String LDAP_BASE_URL = "ldap.base.url";
    public static final String LDAP_BASE_USER_DN = "ldap.base.userDn";
    public static final String LDAP_BASE_USER_DN_PATTERN = "ldap.base.userDnPattern";
    public static final String LDAP_BASE_USER_DN_PATTERN_DELIMITER = "ldap.base.userDnPatternDelimiter";
    public static final String LDAP_EMAIL_DOMAIN = "ldap.emailDomain";
    public static final String LDAP_STORE_CUSTOM_ATTRIBUTES = "ldap.storeCustomAttributes";
    public static final String LDAP_EXTERNAL_GROUPS_WHITELIST = "ldap.externalGroupsWhitelist";
    public static final String LDAP_GROUP_FILE_GROUPS_AS_SCOPES = "ldap/ldap-groups-as-scopes.xml";
    public static final String LDAP_GROUP_FILE_GROUPS_MAP_TO_SCOPES = "ldap/ldap-groups-map-to-scopes.xml";
    public static final String LDAP_GROUP_FILE_GROUPS_NULL_XML = "ldap/ldap-groups-null.xml";
    public static final String LDAP_GROUPS_AUTO_ADD = "ldap.groups.autoAdd";
    public static final String LDAP_GROUPS_FILE = "ldap.groups.file";
    public static final String LDAP_GROUPS_GROUP_ROLE_ATTRIBUTE = "ldap.groups.groupRoleAttribute";
    public static final String LDAP_GROUPS_GROUP_SEARCH_FILTER = "ldap.groups.groupSearchFilter";
    public static final String LDAP_GROUPS_IGNORE_PARTIAL_RESULT_EXCEPTION = "ldap.groups.ignorePartialResultException";
    public static final String LDAP_GROUPS_MAX_SEARCH_DEPTH = "ldap.groups.maxSearchDepth";
    public static final String LDAP_GROUPS_SEARCH_BASE = "ldap.groups.searchBase";
    public static final String LDAP_GROUPS_SEARCH_SUBTREE = "ldap.groups.searchSubtree";
    public static final String LDAP_PROFILE_FILE = "ldap.profile.file";
    public static final String LDAP_PROFILE_FILE_SEARCH_AND_BIND = "ldap/ldap-search-and-bind.xml";
    public static final String LDAP_PROFILE_FILE_SEARCH_AND_COMPARE = "ldap/ldap-search-and-compare.xml";
    public static final String LDAP_PROFILE_FILE_SIMPLE_BIND = "ldap/ldap-simple-bind.xml";
    public static final String LDAP_SSL_SKIPVERIFICATION = "ldap.ssl.skipverification";
    public static final String LDAP_SSL_TLS = "ldap.ssl.tls";
    public static final String MAIL = "mail";
    public static final List<String> VALID_PROFILE_FILES = Collections.unmodifiableList(Arrays.asList("ldap/ldap-search-and-bind.xml", "ldap/ldap-search-and-compare.xml", "ldap/ldap-simple-bind.xml"));
    public static final List<String> VALID_GROUP_FILES = Collections.unmodifiableList(Arrays.asList("ldap/ldap-groups-as-scopes.xml", "ldap/ldap-groups-map-to-scopes.xml", "ldap/ldap-groups-null.xml", "ldap/ldap-groups-populator.xml"));
    public static final List<String> LDAP_PROPERTY_NAMES = Collections.unmodifiableList(Arrays.asList("ldap.attributeMappings", "ldap.base.localPasswordCompare", "ldap.base.mailAttributeName", "ldap.base.mailSubstitute", "ldap.base.mailSubstituteOverridesLdap", "ldap.base.password", "ldap.base.passwordAttributeName", "ldap.base.passwordEncoder", "ldap.base.referral", "ldap.base.searchBase", "ldap.base.searchFilter", "ldap.base.url", "ldap.base.userDn", "ldap.base.userDnPattern", "ldap.base.userDnPatternDelimiter", "ldap.emailDomain", "ldap.externalGroupsWhitelist", "ldap.groups.autoAdd", "ldap.groups.file", "ldap.groups.groupRoleAttribute", "ldap.groups.groupSearchFilter", "ldap.groups.ignorePartialResultException", "ldap.groups.maxSearchDepth", "ldap.groups.searchBase", "ldap.groups.searchSubtree", "ldap.profile.file", "ldap.ssl.skipverification", "ldap.ssl.tls"));
    public static final Map<String, Class<?>> LDAP_PROPERTY_TYPES = new HashMap();
    private String ldapProfileFile;
    private String baseUrl;
    private String referral;
    private Boolean skipSSLVerification;
    private String userDNPattern;
    private String userDNPatternDelimiter;
    private String bindUserDn;
    private String bindPassword;
    private String userSearchBase;
    private String userSearchFilter;
    private String passwordAttributeName;
    private String passwordEncoder;
    private Boolean localPasswordCompare;
    private String mailAttributeName = "mail";
    private String mailSubstitute;
    private Boolean mailSubstituteOverridesLdap = false;
    private String ldapGroupFile = null;
    private String groupSearchBase;
    private String groupSearchFilter;
    private Boolean groupsIgnorePartialResults;
    private Boolean autoAddGroups = true;
    private Boolean groupSearchSubTree = true;
    private int maxGroupSearchDepth = 10;
    private String groupRoleAttribute;
    private String tlsConfiguration = "none";

    public static LdapIdentityProviderDefinition searchAndBindMapGroupToScopes(String baseUrl, String bindUserDn, String bindPassword, String userSearchBase, String userSearchFilter, String groupSearchBase, String groupSearchFilter, String mailAttributeName, String mailSubstitute, Boolean mailSubstituteOverridesLdap, Boolean autoAddGroups, Boolean groupSearchSubTree, int groupMaxSearchDepth, Boolean skipSSLVerification) {
        LdapIdentityProviderDefinition definition = new LdapIdentityProviderDefinition();
        definition.baseUrl = baseUrl;
        definition.bindUserDn = bindUserDn;
        definition.bindPassword = bindPassword;
        definition.userSearchBase = userSearchBase;
        definition.userSearchFilter = userSearchFilter;
        definition.groupSearchBase = groupSearchBase;
        definition.groupSearchFilter = groupSearchFilter;
        definition.mailAttributeName = mailAttributeName;
        definition.mailSubstitute = mailSubstitute;
        definition.ldapProfileFile = LDAP_PROFILE_FILE_SEARCH_AND_BIND;
        definition.ldapGroupFile = LDAP_GROUP_FILE_GROUPS_MAP_TO_SCOPES;
        definition.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
        definition.autoAddGroups = autoAddGroups;
        definition.groupSearchSubTree = groupSearchSubTree;
        definition.maxGroupSearchDepth = groupMaxSearchDepth;
        definition.skipSSLVerification = skipSSLVerification;
        return definition;
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public Boolean isAutoAddGroups() {
        return this.autoAddGroups;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBindPassword() {
        return this.bindPassword;
    }

    public String getBindUserDn() {
        return this.bindUserDn;
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public String getLdapGroupFile() {
        return this.ldapGroupFile;
    }

    public String getLdapProfileFile() {
        return this.ldapProfileFile;
    }

    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    public String getMailSubstitute() {
        return this.mailSubstitute;
    }

    public Boolean isMailSubstituteOverridesLdap() {
        return this.mailSubstituteOverridesLdap == null ? false : this.mailSubstituteOverridesLdap;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public Boolean isGroupSearchSubTree() {
        return this.groupSearchSubTree;
    }

    public int getMaxGroupSearchDepth() {
        return this.maxGroupSearchDepth;
    }

    public Boolean isSkipSSLVerification() {
        return this.skipSSLVerification == null ? false : this.skipSSLVerification;
    }

    public void setAutoAddGroups(Boolean autoAddGroups) {
        this.autoAddGroups = autoAddGroups;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public void setBindUserDn(String bindUserDn) {
        this.bindUserDn = bindUserDn;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setGroupSearchSubTree(Boolean groupSearchSubTree) {
        this.groupSearchSubTree = groupSearchSubTree;
    }

    public void setLdapGroupFile(String ldapGroupFile) {
        if (ldapGroupFile != null && !VALID_GROUP_FILES.contains(ldapGroupFile)) {
            throw new IllegalArgumentException("Invalid profile file:" + ldapGroupFile);
        }
        this.ldapGroupFile = ldapGroupFile;
    }

    public void setLdapProfileFile(String ldapProfileFile) {
        if (ldapProfileFile != null && !VALID_PROFILE_FILES.contains(ldapProfileFile)) {
            throw new IllegalArgumentException("Invalid profile file:" + ldapProfileFile);
        }
        this.ldapProfileFile = ldapProfileFile;
    }

    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    public void setMailSubstitute(String mailSubstitute) {
        this.mailSubstitute = mailSubstitute;
    }

    public void setMailSubstituteOverridesLdap(Boolean mailSubstituteOverridesLdap) {
        this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
    }

    public void setMaxGroupSearchDepth(int maxGroupSearchDepth) {
        this.maxGroupSearchDepth = maxGroupSearchDepth;
    }

    public void setSkipSSLVerification(Boolean skipSSLVerification) {
        this.skipSSLVerification = skipSSLVerification;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public String getUserDNPattern() {
        return this.userDNPattern;
    }

    public void setUserDNPattern(String userDNPattern) {
        this.userDNPattern = userDNPattern;
    }

    public String getPasswordAttributeName() {
        return this.passwordAttributeName;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public String getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(String passwordEncoder) {
        if (passwordEncoder != null && !"org.cloudfoundry.identity.uaa.provider.ldap.DynamicPasswordComparator".equals(passwordEncoder)) {
            throw new IllegalArgumentException("Unknown encoder:" + passwordEncoder);
        }
        this.passwordEncoder = passwordEncoder;
    }

    public String getGroupRoleAttribute() {
        return this.groupRoleAttribute;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        this.groupRoleAttribute = groupRoleAttribute;
    }

    @JsonIgnore
    public Boolean isConfigured() {
        return StringUtils.hasText((String)this.getBaseUrl());
    }

    public Boolean isLocalPasswordCompare() {
        return this.localPasswordCompare;
    }

    public void setLocalPasswordCompare(Boolean localPasswordCompare) {
        this.localPasswordCompare = localPasswordCompare;
    }

    public String getUserDNPatternDelimiter() {
        return this.userDNPatternDelimiter;
    }

    public void setUserDNPatternDelimiter(String userDNPatternDelimiter) {
        this.userDNPatternDelimiter = userDNPatternDelimiter;
    }

    public Boolean isGroupsIgnorePartialResults() {
        return this.groupsIgnorePartialResults;
    }

    public void setGroupsIgnorePartialResults(Boolean groupsIgnorePartialResults) {
        this.groupsIgnorePartialResults = groupsIgnorePartialResults;
    }

    public String getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    public void setTlsConfiguration(String tlsConfiguration) {
        if (tlsConfiguration == null) {
            tlsConfiguration = LDAP_TLS_NONE;
        }
        switch (tlsConfiguration) {
            case "none": 
            case "simple": 
            case "external": {
                this.tlsConfiguration = tlsConfiguration;
                break;
            }
            default: {
                throw new IllegalArgumentException(tlsConfiguration);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LdapIdentityProviderDefinition that = (LdapIdentityProviderDefinition)o;
        if (this.maxGroupSearchDepth != that.maxGroupSearchDepth) {
            return false;
        }
        if (this.ldapProfileFile != null ? !this.ldapProfileFile.equals(that.ldapProfileFile) : that.ldapProfileFile != null) {
            return false;
        }
        if (this.baseUrl != null ? !this.baseUrl.equals(that.baseUrl) : that.baseUrl != null) {
            return false;
        }
        if (this.referral != null ? !this.referral.equals(that.referral) : that.referral != null) {
            return false;
        }
        if (this.userDNPattern != null ? !this.userDNPattern.equals(that.userDNPattern) : that.userDNPattern != null) {
            return false;
        }
        if (this.userDNPatternDelimiter != null ? !this.userDNPatternDelimiter.equals(that.userDNPatternDelimiter) : that.userDNPatternDelimiter != null) {
            return false;
        }
        if (this.bindUserDn != null ? !this.bindUserDn.equals(that.bindUserDn) : that.bindUserDn != null) {
            return false;
        }
        if (this.bindPassword != null ? !this.bindPassword.equals(that.bindPassword) : that.bindPassword != null) {
            return false;
        }
        if (this.userSearchBase != null ? !this.userSearchBase.equals(that.userSearchBase) : that.userSearchBase != null) {
            return false;
        }
        if (this.userSearchFilter != null ? !this.userSearchFilter.equals(that.userSearchFilter) : that.userSearchFilter != null) {
            return false;
        }
        if (this.passwordAttributeName != null ? !this.passwordAttributeName.equals(that.passwordAttributeName) : that.passwordAttributeName != null) {
            return false;
        }
        if (this.passwordEncoder != null ? !this.passwordEncoder.equals(that.passwordEncoder) : that.passwordEncoder != null) {
            return false;
        }
        if (this.localPasswordCompare != null ? !this.localPasswordCompare.equals(that.localPasswordCompare) : that.localPasswordCompare != null) {
            return false;
        }
        if (this.mailAttributeName != null ? !this.mailAttributeName.equals(that.mailAttributeName) : that.mailAttributeName != null) {
            return false;
        }
        if (this.mailSubstitute != null ? !this.mailSubstitute.equals(that.mailSubstitute) : that.mailSubstitute != null) {
            return false;
        }
        if (this.mailSubstituteOverridesLdap != null ? !this.mailSubstituteOverridesLdap.equals(that.mailSubstituteOverridesLdap) : that.mailSubstituteOverridesLdap != null) {
            return false;
        }
        if (this.ldapGroupFile != null ? !this.ldapGroupFile.equals(that.ldapGroupFile) : that.ldapGroupFile != null) {
            return false;
        }
        if (this.groupSearchBase != null ? !this.groupSearchBase.equals(that.groupSearchBase) : that.groupSearchBase != null) {
            return false;
        }
        if (this.groupSearchFilter != null ? !this.groupSearchFilter.equals(that.groupSearchFilter) : that.groupSearchFilter != null) {
            return false;
        }
        if (this.groupsIgnorePartialResults != null ? !this.groupsIgnorePartialResults.equals(that.groupsIgnorePartialResults) : that.groupsIgnorePartialResults != null) {
            return false;
        }
        if (this.autoAddGroups != null ? !this.autoAddGroups.equals(that.autoAddGroups) : that.autoAddGroups != null) {
            return false;
        }
        if (this.groupSearchSubTree != null ? !this.groupSearchSubTree.equals(that.groupSearchSubTree) : that.groupSearchSubTree != null) {
            return false;
        }
        return !(this.groupRoleAttribute == null ? that.groupRoleAttribute != null : !this.groupRoleAttribute.equals(that.groupRoleAttribute));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        return result;
    }

    static {
        LDAP_PROPERTY_TYPES.put(LDAP_ATTRIBUTE_MAPPINGS, Map.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_LOCAL_PASSWORD_COMPARE, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_MAIL_ATTRIBUTE_NAME, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_MAIL_SUBSTITUTE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_MAIL_SUBSTITUTE_OVERRIDES_LDAP, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_PASSWORD, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_PASSWORD_ATTRIBUTE_NAME, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_PASSWORD_ENCODER, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_REFERRAL, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_SEARCH_BASE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_SEARCH_FILTER, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_URL, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_USER_DN, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_USER_DN_PATTERN, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_BASE_USER_DN_PATTERN_DELIMITER, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_EMAIL_DOMAIN, List.class);
        LDAP_PROPERTY_TYPES.put(LDAP_EXTERNAL_GROUPS_WHITELIST, List.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_AUTO_ADD, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_FILE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_GROUP_ROLE_ATTRIBUTE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_GROUP_SEARCH_FILTER, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_IGNORE_PARTIAL_RESULT_EXCEPTION, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_MAX_SEARCH_DEPTH, Integer.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_SEARCH_BASE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_GROUPS_SEARCH_SUBTREE, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_PROFILE_FILE, String.class);
        LDAP_PROPERTY_TYPES.put(LDAP_SSL_SKIPVERIFICATION, Boolean.class);
        LDAP_PROPERTY_TYPES.put(LDAP_SSL_TLS, String.class);
    }

    public static class LdapConfigEnvironment
    extends AbstractEnvironment {
        public LdapConfigEnvironment(MapPropertySource source) {
            this.getPropertySources().addFirst((PropertySource)source);
        }
    }
}

