/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.mfa.AbstractMfaProviderConfig;
import org.cloudfoundry.identity.uaa.mfa.GoogleMfaProviderConfig;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=MfaProviderDeserializer.class)
public class MfaProvider<T extends AbstractMfaProviderConfig> {
    public static final String FIELD_IDENTITY_ZONE_ID = "identityZoneId";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_LAST_MODIFIED = "last_modified";
    public static final String FIELD_ID = "id";
    private String id;
    private String name;
    private String identityZoneId;
    private AbstractMfaProviderConfig config;
    private MfaProviderType type;
    private Date created;
    @JsonProperty(value="last_modified")
    private Date lastModified;

    public Date getCreated() {
        return this.created;
    }

    public MfaProvider<T> setCreated(Date created) {
        this.created = created;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public MfaProvider<T> setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public MfaProvider<T> setIdentityZoneId(String identityZoneId) {
        this.identityZoneId = identityZoneId;
        return this;
    }

    public T getConfig() {
        return (T)this.config;
    }

    public MfaProvider<T> setConfig(T config) {
        this.config = config;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public MfaProvider<T> setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MfaProvider<T> setName(String name) {
        this.name = name;
        return this;
    }

    public MfaProviderType getType() {
        return this.type;
    }

    public MfaProvider<T> setType(MfaProviderType type) {
        this.type = type;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MfaProvider)) {
            return false;
        }
        MfaProvider that = (MfaProvider)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getIdentityZoneId() != null ? this.getIdentityZoneId().equals(that.getIdentityZoneId()) : that.getIdentityZoneId() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getIdentityZoneId() != null ? this.getIdentityZoneId().hashCode() : 0);
        return result;
    }

    public static class MfaProviderDeserializer
    extends JsonDeserializer<MfaProvider> {
        public MfaProvider deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            MfaProviderType type;
            MfaProvider<GoogleMfaProviderConfig> result = new MfaProvider<GoogleMfaProviderConfig>();
            JsonNode node = JsonUtils.readTree((JsonParser)p);
            try {
                type = MfaProviderType.forValue(JsonUtils.getNodeAsString((JsonNode)node, (String)MfaProvider.FIELD_TYPE, (String)"google-authenticator"));
            }
            catch (IllegalArgumentException e) {
                type = null;
            }
            JsonNode configNode = node.get("config");
            String config = configNode != null ? (configNode.isTextual() ? configNode.textValue() : configNode.toString()) : null;
            AbstractMfaProviderConfig definition = null;
            if (type != null) {
                switch (type) {
                    case GOOGLE_AUTHENTICATOR: {
                        definition = StringUtils.hasText((String)config) ? (AbstractMfaProviderConfig)JsonUtils.readValue((String)config, GoogleMfaProviderConfig.class) : new GoogleMfaProviderConfig();
                        break;
                    }
                }
            }
            result.setConfig((GoogleMfaProviderConfig)definition);
            result.setType(type);
            result.setName(JsonUtils.getNodeAsString((JsonNode)node, (String)MfaProvider.FIELD_NAME, null));
            result.setId(JsonUtils.getNodeAsString((JsonNode)node, (String)MfaProvider.FIELD_ID, null));
            result.setIdentityZoneId(JsonUtils.getNodeAsString((JsonNode)node, (String)MfaProvider.FIELD_IDENTITY_ZONE_ID, null));
            result.setCreated(JsonUtils.getNodeAsDate((JsonNode)node, (String)MfaProvider.FIELD_CREATED));
            result.setLastModified(JsonUtils.getNodeAsDate((JsonNode)node, (String)MfaProvider.FIELD_LAST_MODIFIED));
            return result;
        }
    }

    public static enum MfaProviderType {
        GOOGLE_AUTHENTICATOR;

        private static Map<String, MfaProviderType> namesMap;

        @JsonCreator
        public static MfaProviderType forValue(String value) {
            return namesMap.get(value);
        }

        @JsonValue
        public String toValue() {
            for (Map.Entry<String, MfaProviderType> entry : namesMap.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
            return null;
        }

        public static Set<String> getStringValues() {
            return namesMap.keySet();
        }

        static {
            namesMap = new HashMap<String, MfaProviderType>();
            namesMap.put("google-authenticator", GOOGLE_AUTHENTICATOR);
        }
    }
}

