/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

public abstract class GenericPasswordPolicy<T extends GenericPasswordPolicy<T>> {
    private int minLength;
    private int maxLength;
    private int requireUpperCaseCharacter;
    private int requireLowerCaseCharacter;
    private int requireDigit;
    private int requireSpecialCharacter;

    public GenericPasswordPolicy() {
        this.requireSpecialCharacter = -1;
        this.requireDigit = -1;
        this.requireLowerCaseCharacter = -1;
        this.requireUpperCaseCharacter = -1;
        this.maxLength = -1;
        this.minLength = -1;
    }

    public GenericPasswordPolicy(int minLength, int maxLength, int requireUpperCaseCharacter, int requireLowerCaseCharacter, int requireDigit, int requireSpecialCharacter) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.requireUpperCaseCharacter = requireUpperCaseCharacter;
        this.requireLowerCaseCharacter = requireLowerCaseCharacter;
        this.requireDigit = requireDigit;
        this.requireSpecialCharacter = requireSpecialCharacter;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getRequireUpperCaseCharacter() {
        return this.requireUpperCaseCharacter;
    }

    public int getRequireLowerCaseCharacter() {
        return this.requireLowerCaseCharacter;
    }

    public int getRequireDigit() {
        return this.requireDigit;
    }

    public T setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return (T)this;
    }

    public T setMinLength(int minLength) {
        this.minLength = minLength;
        return (T)this;
    }

    public T setRequireDigit(int requireDigit) {
        this.requireDigit = requireDigit;
        return (T)this;
    }

    public T setRequireLowerCaseCharacter(int requireLowerCaseCharacter) {
        this.requireLowerCaseCharacter = requireLowerCaseCharacter;
        return (T)this;
    }

    public T setRequireUpperCaseCharacter(int requireUpperCaseCharacter) {
        this.requireUpperCaseCharacter = requireUpperCaseCharacter;
        return (T)this;
    }

    public int getRequireSpecialCharacter() {
        return this.requireSpecialCharacter;
    }

    public T setRequireSpecialCharacter(int requireSpecialCharacter) {
        this.requireSpecialCharacter = requireSpecialCharacter;
        return (T)this;
    }

    public boolean allPresentAndPositive() {
        return this.minLength >= 0 && this.maxLength >= 0 && this.requireUpperCaseCharacter >= 0 && this.requireLowerCaseCharacter >= 0 && this.requireDigit >= 0 && this.requireSpecialCharacter >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPasswordPolicy that = (GenericPasswordPolicy)o;
        if (this.minLength != that.minLength) {
            return false;
        }
        if (this.maxLength != that.maxLength) {
            return false;
        }
        if (this.requireUpperCaseCharacter != that.requireUpperCaseCharacter) {
            return false;
        }
        if (this.requireLowerCaseCharacter != that.requireLowerCaseCharacter) {
            return false;
        }
        if (this.requireDigit != that.requireDigit) {
            return false;
        }
        return this.requireSpecialCharacter == that.requireSpecialCharacter;
    }

    public int hashCode() {
        int result = this.minLength;
        result = 31 * result + this.maxLength;
        result = 31 * result + this.requireUpperCaseCharacter;
        result = 31 * result + this.requireLowerCaseCharacter;
        result = 31 * result + this.requireDigit;
        result = 31 * result + this.requireSpecialCharacter;
        return result;
    }
}

