/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import com.fasterxml.jackson.annotation.JsonProperty;

public class OpenIdConfiguration {
    @JsonProperty(value="issuer")
    private String issuer;
    @JsonProperty(value="authorization_endpoint")
    private String authUrl;
    @JsonProperty(value="token_endpoint")
    private String tokenUrl;
    @JsonProperty(value="token_endpoint_auth_methods_supported")
    private String[] tokenAMR = new String[]{"client_secret_basic", "client_secret_post"};
    @JsonProperty(value="token_endpoint_auth_signing_alg_values_supported")
    private String[] tokenEndpointAuthSigningValues = new String[]{"RS256", "HS256"};
    @JsonProperty(value="userinfo_endpoint")
    private String userInfoUrl;
    @JsonProperty(value="jwks_uri")
    private String jwksUri;
    @JsonProperty(value="scopes_supported")
    private String[] scopes = new String[]{"openid", "profile", "email", "phone", "roles", "user_attributes"};
    @JsonProperty(value="response_types_supported")
    private String[] responseTypes = new String[]{"code", "code id_token", "id_token", "token id_token"};
    @JsonProperty(value="subject_types_supported")
    private String[] subjectTypesSupported = new String[]{"public"};
    @JsonProperty(value="id_token_signing_alg_values_supported")
    private String[] idTokenSigningAlgValues = new String[]{"RS256", "HS256"};
    @JsonProperty(value="id_token_encryption_alg_values_supported")
    private String[] requestObjectSigningAlgValues = new String[]{"none"};
    @JsonProperty(value="claim_types_supported")
    private String[] claimTypesSupported = new String[]{"normal"};
    @JsonProperty(value="claims_supported")
    private String[] claimsSupported = new String[]{"sub", "user_name", "origin", "iss", "auth_time", "amr", "acr", "client_id", "aud", "zid", "grant_type", "user_id", "azp", "scope", "exp", "iat", "jti", "rev_sig", "cid", "given_name", "family_name", "phone_number", "email"};
    @JsonProperty(value="claims_parameter_supported")
    private boolean claimsParameterSupported = false;
    @JsonProperty(value="service_documentation")
    private String serviceDocumentation = "http://docs.cloudfoundry.org/api/uaa/";
    @JsonProperty(value="ui_locales_supported")
    private String[] uiLocalesSupported = new String[]{"en-US"};

    public OpenIdConfiguration() {
    }

    public OpenIdConfiguration(String contextPath, String issuer) {
        this.issuer = issuer;
        this.authUrl = contextPath + "/oauth/authorize";
        this.tokenUrl = contextPath + "/oauth/token";
        this.userInfoUrl = contextPath + "/userinfo";
        this.jwksUri = contextPath + "/token_keys";
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public String[] getTokenAMR() {
        return this.tokenAMR;
    }

    public void setTokenAMR(String[] tokenAMR) {
        this.tokenAMR = tokenAMR;
    }

    public String[] getTokenEndpointAuthSigningValues() {
        return this.tokenEndpointAuthSigningValues;
    }

    public void setTokenEndpointAuthSigningValues(String[] tokenEndpointAuthSigningValues) {
        this.tokenEndpointAuthSigningValues = tokenEndpointAuthSigningValues;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public String[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(String[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String[] getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(String[] subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public String[] getIdTokenSigningAlgValues() {
        return this.idTokenSigningAlgValues;
    }

    public void setIdTokenSigningAlgValues(String[] idTokenSigningAlgValues) {
        this.idTokenSigningAlgValues = idTokenSigningAlgValues;
    }

    public String[] getRequestObjectSigningAlgValues() {
        return this.requestObjectSigningAlgValues;
    }

    public void setRequestObjectSigningAlgValues(String[] requestObjectSigningAlgValues) {
        this.requestObjectSigningAlgValues = requestObjectSigningAlgValues;
    }

    public String[] getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(String[] claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public String[] getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setClaimsSupported(String[] claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public boolean isClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    public String[] getUiLocalesSupported() {
        return this.uiLocalesSupported;
    }

    public void setUiLocalesSupported(String[] uiLocalesSupported) {
        this.uiLocalesSupported = uiLocalesSupported;
    }
}

