/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.services.ServicePlan;
import org.cloudfoundry.operations.services._ServiceOffering;
import org.immutables.value.Generated;

@Generated(from="_ServiceOffering", generator="Immutables")
public final class ServiceOffering
extends _ServiceOffering {
    private final String description;
    private final String id;
    private final String label;
    private final List<ServicePlan> servicePlans;

    private ServiceOffering(Builder builder) {
        this.description = builder.description;
        this.id = builder.id;
        this.label = builder.label;
        this.servicePlans = ServiceOffering.createUnmodifiableList(true, builder.servicePlans);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public List<ServicePlan> getServicePlans() {
        return this.servicePlans;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceOffering && this.equalTo((ServiceOffering)another);
    }

    private boolean equalTo(ServiceOffering another) {
        return this.description.equals(another.description) && this.id.equals(another.id) && this.label.equals(another.label) && this.servicePlans.equals(another.servicePlans);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.servicePlans.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceOffering{description=" + this.description + ", id=" + this.id + ", label=" + this.label + ", servicePlans=" + this.servicePlans + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ServiceOffering", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTION = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_LABEL = 4L;
        private long initBits = 7L;
        private String description;
        private String id;
        private String label;
        private List<ServicePlan> servicePlans = new ArrayList<ServicePlan>();

        private Builder() {
        }

        public final Builder from(ServiceOffering instance) {
            return this.from((_ServiceOffering)instance);
        }

        final Builder from(_ServiceOffering instance) {
            Objects.requireNonNull(instance, "instance");
            this.description(instance.getDescription());
            this.id(instance.getId());
            this.label(instance.getLabel());
            this.addAllServicePlans(instance.getServicePlans());
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder servicePlan(ServicePlan element) {
            this.servicePlans.add(Objects.requireNonNull(element, "servicePlans element"));
            return this;
        }

        public final Builder servicePlans(ServicePlan ... elements) {
            for (ServicePlan element : elements) {
                this.servicePlans.add(Objects.requireNonNull(element, "servicePlans element"));
            }
            return this;
        }

        public final Builder servicePlans(Iterable<? extends ServicePlan> elements) {
            this.servicePlans.clear();
            return this.addAllServicePlans(elements);
        }

        public final Builder addAllServicePlans(Iterable<? extends ServicePlan> elements) {
            for (ServicePlan servicePlan : elements) {
                this.servicePlans.add(Objects.requireNonNull(servicePlan, "servicePlans element"));
            }
            return this;
        }

        public ServiceOffering build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceOffering(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build ServiceOffering, some of required attributes are not set " + attributes;
        }
    }
}

