/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications._RunApplicationTaskRequest;

public final class RunApplicationTaskRequest
extends _RunApplicationTaskRequest {
    private final String applicationName;
    private final String command;
    @Nullable
    private final Integer disk;
    @Nullable
    private final Integer memory;
    @Nullable
    private final String taskName;

    private RunApplicationTaskRequest(Builder builder) {
        this.applicationName = builder.applicationName;
        this.command = builder.command;
        this.disk = builder.disk;
        this.memory = builder.memory;
        this.taskName = builder.taskName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public Integer getDisk() {
        return this.disk;
    }

    @Override
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    @Nullable
    public String getTaskName() {
        return this.taskName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RunApplicationTaskRequest && this.equalTo((RunApplicationTaskRequest)another);
    }

    private boolean equalTo(RunApplicationTaskRequest another) {
        return this.applicationName.equals(another.applicationName) && this.command.equals(another.command) && Objects.equals(this.disk, another.disk) && Objects.equals(this.memory, another.memory) && Objects.equals(this.taskName, another.taskName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationName.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + Objects.hashCode(this.disk);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + Objects.hashCode(this.taskName);
        return h;
    }

    public String toString() {
        return "RunApplicationTaskRequest{applicationName=" + this.applicationName + ", command=" + this.command + ", disk=" + this.disk + ", memory=" + this.memory + ", taskName=" + this.taskName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_NAME = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private long initBits = 3L;
        private String applicationName;
        private String command;
        private Integer disk;
        private Integer memory;
        private String taskName;

        private Builder() {
        }

        public final Builder from(RunApplicationTaskRequest instance) {
            return this.from((_RunApplicationTaskRequest)instance);
        }

        final Builder from(_RunApplicationTaskRequest instance) {
            String taskNameValue;
            Integer memoryValue;
            Objects.requireNonNull(instance, "instance");
            this.applicationName(instance.getApplicationName());
            this.command(instance.getCommand());
            Integer diskValue = instance.getDisk();
            if (diskValue != null) {
                this.disk(diskValue);
            }
            if ((memoryValue = instance.getMemory()) != null) {
                this.memory(memoryValue);
            }
            if ((taskNameValue = instance.getTaskName()) != null) {
                this.taskName(taskNameValue);
            }
            return this;
        }

        public final Builder applicationName(String applicationName) {
            this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder disk(@Nullable Integer disk) {
            this.disk = disk;
            return this;
        }

        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Builder taskName(@Nullable String taskName) {
            this.taskName = taskName;
            return this;
        }

        public RunApplicationTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RunApplicationTaskRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build RunApplicationTaskRequest, some of required attributes are not set " + attributes;
        }
    }
}

