/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebrokers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Pagination;
import org.cloudfoundry.client.v3.servicebrokers.ServiceBrokerResource;
import org.cloudfoundry.client.v3.servicebrokers._ListServiceBrokersResponse;
import org.immutables.value.Generated;

@Generated(from="_ListServiceBrokersResponse", generator="Immutables")
public final class ListServiceBrokersResponse
extends _ListServiceBrokersResponse {
    @Nullable
    private final Pagination pagination;
    @Nullable
    private final List<ServiceBrokerResource> resources;

    private ListServiceBrokersResponse(Builder builder) {
        this.pagination = builder.pagination;
        this.resources = builder.resources == null ? null : ListServiceBrokersResponse.createUnmodifiableList(true, builder.resources);
    }

    @Override
    @JsonProperty(value="pagination")
    @Nullable
    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    @JsonProperty(value="resources")
    @Nullable
    public List<ServiceBrokerResource> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceBrokersResponse && this.equalTo((ListServiceBrokersResponse)another);
    }

    private boolean equalTo(ListServiceBrokersResponse another) {
        return Objects.equals(this.pagination, another.pagination) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagination);
        h += (h << 5) + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "ListServiceBrokersResponse{pagination=" + this.pagination + ", resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListServiceBrokersResponse fromJson(Json json) {
        Builder builder = ListServiceBrokersResponse.builder();
        if (json.pagination != null) {
            builder.pagination(json.pagination);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceBrokersResponse", generator="Immutables")
    public static final class Builder {
        private Pagination pagination;
        private List<ServiceBrokerResource> resources = null;

        private Builder() {
        }

        public final Builder from(ListServiceBrokersResponse instance) {
            return this.from((_ListServiceBrokersResponse)instance);
        }

        final Builder from(_ListServiceBrokersResponse instance) {
            List resourcesValue;
            Objects.requireNonNull(instance, "instance");
            Pagination paginationValue = instance.getPagination();
            if (paginationValue != null) {
                this.pagination(paginationValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        @JsonProperty(value="pagination")
        public final Builder pagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public final Builder resource(ServiceBrokerResource element) {
            if (this.resources == null) {
                this.resources = new ArrayList<ServiceBrokerResource>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(ServiceBrokerResource ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<ServiceBrokerResource>();
            }
            for (ServiceBrokerResource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @JsonProperty(value="resources")
        public final Builder resources(@Nullable Iterable<? extends ServiceBrokerResource> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<ServiceBrokerResource>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends ServiceBrokerResource> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<ServiceBrokerResource>();
            }
            for (ServiceBrokerResource serviceBrokerResource : elements) {
                this.resources.add(Objects.requireNonNull(serviceBrokerResource, "resources element"));
            }
            return this;
        }

        public ListServiceBrokersResponse build() {
            return new ListServiceBrokersResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListServiceBrokersResponse", generator="Immutables")
    static final class Json
    extends _ListServiceBrokersResponse {
        Pagination pagination;
        List<ServiceBrokerResource> resources = null;

        Json() {
        }

        @JsonProperty(value="pagination")
        public void setPagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
        }

        @JsonProperty(value="resources")
        public void setResources(@Nullable List<ServiceBrokerResource> resources) {
            this.resources = resources;
        }

        @Override
        public Pagination getPagination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ServiceBrokerResource> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

