/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BuildState {
    FAILED("FAILED"),
    STAGED("STAGED"),
    STAGING("STAGING");

    private final String value;

    private BuildState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static BuildState from(String s) {
        switch (s.toLowerCase()) {
            case "failed": {
                return FAILED;
            }
            case "staged": {
                return STAGED;
            }
            case "staging": {
                return STAGING;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown build state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

