/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.groups._MapExternalGroupRequest;

public final class MapExternalGroupRequest
extends _MapExternalGroupRequest {
    private final String externalGroup;
    private final String groupId;
    @Nullable
    private final String origin;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private MapExternalGroupRequest(Builder builder) {
        this.externalGroup = builder.externalGroup;
        this.groupId = builder.groupId;
        this.origin = builder.origin;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    public String getExternalGroup() {
        return this.externalGroup;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MapExternalGroupRequest && this.equalTo((MapExternalGroupRequest)another);
    }

    private boolean equalTo(MapExternalGroupRequest another) {
        return this.externalGroup.equals(another.externalGroup) && this.groupId.equals(another.groupId) && Objects.equals(this.origin, another.origin) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.externalGroup.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "MapExternalGroupRequest{externalGroup=" + this.externalGroup + ", groupId=" + this.groupId + ", origin=" + this.origin + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_GROUP = 1L;
        private static final long INIT_BIT_GROUP_ID = 2L;
        private long initBits = 3L;
        private String externalGroup;
        private String groupId;
        private String origin;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MapExternalGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_MapExternalGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _MapExternalGroupRequest) {
                instance = (_MapExternalGroupRequest)object;
                this.externalGroup(((_MapExternalGroupRequest)instance).getExternalGroup());
                this.groupId(((_MapExternalGroupRequest)instance).getGroupId());
                String originValue = ((_MapExternalGroupRequest)instance).getOrigin();
                if (originValue != null) {
                    this.origin(originValue);
                }
            }
        }

        public final Builder externalGroup(String externalGroup) {
            this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public MapExternalGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new MapExternalGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("externalGroup");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("groupId");
            }
            return "Cannot build MapExternalGroupRequest, some of required attributes are not set " + attributes;
        }
    }
}

