/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients._UpdateMetadataRequest;

public final class UpdateMetadataRequest
extends _UpdateMetadataRequest {
    @Nullable
    private final String appIcon;
    @Nullable
    private final String appLaunchUrl;
    private final String clientId;
    @Nullable
    private final String clientName;
    @Nullable
    private final Boolean showOnHomePage;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private UpdateMetadataRequest(Builder builder) {
        this.appIcon = builder.appIcon;
        this.appLaunchUrl = builder.appLaunchUrl;
        this.clientId = builder.clientId;
        this.clientName = builder.clientName;
        this.showOnHomePage = builder.showOnHomePage;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @Nullable
    public String getAppIcon() {
        return this.appIcon;
    }

    @Override
    @Nullable
    public String getAppLaunchUrl() {
        return this.appLaunchUrl;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    @Override
    @Nullable
    public Boolean getShowOnHomePage() {
        return this.showOnHomePage;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateMetadataRequest && this.equalTo((UpdateMetadataRequest)another);
    }

    private boolean equalTo(UpdateMetadataRequest another) {
        return Objects.equals(this.appIcon, another.appIcon) && Objects.equals(this.appLaunchUrl, another.appLaunchUrl) && this.clientId.equals(another.clientId) && Objects.equals(this.clientName, another.clientName) && Objects.equals(this.showOnHomePage, another.showOnHomePage) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.appIcon);
        h += (h << 5) + Objects.hashCode(this.appLaunchUrl);
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientName);
        h += (h << 5) + Objects.hashCode(this.showOnHomePage);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "UpdateMetadataRequest{appIcon=" + this.appIcon + ", appLaunchUrl=" + this.appLaunchUrl + ", clientId=" + this.clientId + ", clientName=" + this.clientName + ", showOnHomePage=" + this.showOnHomePage + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private String appIcon;
        private String appLaunchUrl;
        private String clientId;
        private String clientName;
        private Boolean showOnHomePage;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateMetadataRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UpdateMetadataRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _UpdateMetadataRequest) {
                String appLaunchUrlValue;
                String clientNameValue;
                instance = (_UpdateMetadataRequest)object;
                String appIconValue = ((_UpdateMetadataRequest)instance).getAppIcon();
                if (appIconValue != null) {
                    this.appIcon(appIconValue);
                }
                this.clientId(((_UpdateMetadataRequest)instance).getClientId());
                Boolean showOnHomePageValue = ((_UpdateMetadataRequest)instance).getShowOnHomePage();
                if (showOnHomePageValue != null) {
                    this.showOnHomePage(showOnHomePageValue);
                }
                if ((clientNameValue = ((_UpdateMetadataRequest)instance).getClientName()) != null) {
                    this.clientName(clientNameValue);
                }
                if ((appLaunchUrlValue = ((_UpdateMetadataRequest)instance).getAppLaunchUrl()) != null) {
                    this.appLaunchUrl(appLaunchUrlValue);
                }
            }
        }

        public final Builder appIcon(@Nullable String appIcon) {
            this.appIcon = appIcon;
            return this;
        }

        public final Builder appLaunchUrl(@Nullable String appLaunchUrl) {
            this.appLaunchUrl = appLaunchUrl;
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientName(@Nullable String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final Builder showOnHomePage(@Nullable Boolean showOnHomePage) {
            this.showOnHomePage = showOnHomePage;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public UpdateMetadataRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateMetadataRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build UpdateMetadataRequest, some of required attributes are not set " + attributes;
        }
    }
}

