/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.doppler._ValueMetric;

public final class ValueMetric
extends _ValueMetric {
    private final String name;
    private final String unit;
    private final Double value;

    private ValueMetric(Builder builder) {
        this.name = builder.name;
        this.unit = builder.unit;
        this.value = builder.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public Double value() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ValueMetric && this.equalTo((ValueMetric)another);
    }

    private boolean equalTo(ValueMetric another) {
        return this.name.equals(another.name) && this.unit.equals(another.unit) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.unit.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ValueMetric{name=" + this.name + ", unit=" + this.unit + ", value=" + this.value + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_UNIT = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        private String name;
        private String unit;
        private Double value;

        private Builder() {
        }

        public final Builder from(ValueMetric instance) {
            return this.from((_ValueMetric)instance);
        }

        final Builder from(_ValueMetric instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.unit(instance.getUnit());
            this.value(instance.value());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unit(String unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder value(Double value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ValueMetric build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ValueMetric(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ValueMetric, some of required attributes are not set " + attributes;
        }
    }
}

