/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.packages.PackageData;
import org.cloudfoundry.client.v3.packages.PackageRelationships;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages._CreatePackageRequest;

public final class CreatePackageRequest
extends _CreatePackageRequest {
    @Nullable
    private final PackageData data;
    private final PackageRelationships relationships;
    private final PackageType type;

    private CreatePackageRequest(Builder builder) {
        this.data = builder.data;
        this.relationships = builder.relationships;
        this.type = builder.type;
    }

    @Override
    @Nullable
    public PackageData getData() {
        return this.data;
    }

    @Override
    public PackageRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    public PackageType getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreatePackageRequest && this.equalTo((CreatePackageRequest)another);
    }

    private boolean equalTo(CreatePackageRequest another) {
        return Objects.equals(this.data, another.data) && this.relationships.equals(another.relationships) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "CreatePackageRequest{data=" + this.data + ", relationships=" + this.relationships + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private PackageData data;
        private PackageRelationships relationships;
        private PackageType type;

        private Builder() {
        }

        public final Builder from(CreatePackageRequest instance) {
            return this.from((_CreatePackageRequest)instance);
        }

        final Builder from(_CreatePackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            PackageData dataValue = instance.getData();
            if (dataValue != null) {
                this.data(dataValue);
            }
            this.relationships(instance.getRelationships());
            this.type(instance.getType());
            return this;
        }

        public final Builder data(@Nullable PackageData data) {
            this.data = data;
            return this;
        }

        public final Builder relationships(PackageRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(PackageType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreatePackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreatePackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreatePackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

