/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ChecksumType {
    SHA1("sha1"),
    SHA256("sha256");

    private final String value;

    private ChecksumType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ChecksumType from(String s) {
        switch (s.toLowerCase()) {
            case "sha1": {
                return SHA1;
            }
            case "sha256": {
                return SHA256;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown checksum type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

