/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.securitygroups._DeleteSecurityGroupRequest;

public final class DeleteSecurityGroupRequest
extends _DeleteSecurityGroupRequest {
    @Nullable
    private final Boolean async;
    private final String securityGroupId;

    private DeleteSecurityGroupRequest(Builder builder) {
        this.async = builder.async;
        this.securityGroupId = builder.securityGroupId;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteSecurityGroupRequest && this.equalTo((DeleteSecurityGroupRequest)another);
    }

    private boolean equalTo(DeleteSecurityGroupRequest another) {
        return Objects.equals(this.async, another.async) && this.securityGroupId.equals(another.securityGroupId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.async);
        h += (h << 5) + this.securityGroupId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteSecurityGroupRequest{async=" + this.async + ", securityGroupId=" + this.securityGroupId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SECURITY_GROUP_ID = 1L;
        private long initBits = 1L;
        private Boolean async;
        private String securityGroupId;

        private Builder() {
        }

        public final Builder from(DeleteSecurityGroupRequest instance) {
            return this.from((_DeleteSecurityGroupRequest)instance);
        }

        final Builder from(_DeleteSecurityGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean asyncValue = instance.getAsync();
            if (asyncValue != null) {
                this.async(asyncValue);
            }
            this.securityGroupId(instance.getSecurityGroupId());
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteSecurityGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteSecurityGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("securityGroupId");
            }
            return "Cannot build DeleteSecurityGroupRequest, some of required attributes are not set " + attributes;
        }
    }
}

