/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applicationusageevents;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.applicationusageevents._ListApplicationUsageEventsRequest;

public final class ListApplicationUsageEventsRequest
extends _ListApplicationUsageEventsRequest {
    @Nullable
    private final String afterApplicationUsageEventId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListApplicationUsageEventsRequest(Builder builder) {
        this.afterApplicationUsageEventId = builder.afterApplicationUsageEventId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public String getAfterApplicationUsageEventId() {
        return this.afterApplicationUsageEventId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationUsageEventsRequest && this.equalTo((ListApplicationUsageEventsRequest)another);
    }

    private boolean equalTo(ListApplicationUsageEventsRequest another) {
        return Objects.equals(this.afterApplicationUsageEventId, another.afterApplicationUsageEventId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.afterApplicationUsageEventId);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListApplicationUsageEventsRequest{afterApplicationUsageEventId=" + this.afterApplicationUsageEventId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String afterApplicationUsageEventId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListApplicationUsageEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListApplicationUsageEventsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String afterApplicationUsageEventIdValue;
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationUsageEventsRequest && (afterApplicationUsageEventIdValue = ((_ListApplicationUsageEventsRequest)(instance = (_ListApplicationUsageEventsRequest)object)).getAfterApplicationUsageEventId()) != null) {
                this.afterApplicationUsageEventId(afterApplicationUsageEventIdValue);
            }
        }

        public final Builder afterApplicationUsageEventId(@Nullable String afterApplicationUsageEventId) {
            this.afterApplicationUsageEventId = afterApplicationUsageEventId;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationUsageEventsRequest build() {
            return new ListApplicationUsageEventsRequest(this);
        }
    }
}

