/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.domains;

import java.util.Map;
import org.cloudfoundry.client.v2.domains.CreateDomainRequest;
import org.cloudfoundry.client.v2.domains.CreateDomainResponse;
import org.cloudfoundry.client.v2.domains.DeleteDomainRequest;
import org.cloudfoundry.client.v2.domains.DeleteDomainResponse;
import org.cloudfoundry.client.v2.domains.Domains;
import org.cloudfoundry.client.v2.domains.GetDomainRequest;
import org.cloudfoundry.client.v2.domains.GetDomainResponse;
import org.cloudfoundry.client.v2.domains.ListDomainSpacesRequest;
import org.cloudfoundry.client.v2.domains.ListDomainSpacesResponse;
import org.cloudfoundry.client.v2.domains.ListDomainsRequest;
import org.cloudfoundry.client.v2.domains.ListDomainsResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorDomains
extends AbstractClientV2Operations
implements Domains {
    public ReactorDomains(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateDomainResponse> create(CreateDomainRequest request) {
        return this.post(request, CreateDomainResponse.class, builder -> builder.pathSegment(new String[]{"domains"})).checkpoint();
    }

    public Mono<DeleteDomainResponse> delete(DeleteDomainRequest request) {
        return this.delete(request, DeleteDomainResponse.class, builder -> builder.pathSegment(new String[]{"domains", request.getDomainId()})).checkpoint();
    }

    public Mono<GetDomainResponse> get(GetDomainRequest request) {
        return this.get((Object)request, GetDomainResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains", request.getDomainId()})).checkpoint();
    }

    public Mono<ListDomainsResponse> list(ListDomainsRequest request) {
        return this.get((Object)request, ListDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains"})).checkpoint();
    }

    public Mono<ListDomainSpacesResponse> listSpaces(ListDomainSpacesRequest request) {
        return this.get((Object)request, ListDomainSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains", request.getDomainId(), "spaces"})).checkpoint();
    }
}

