/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.servicebrokers;

import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v3.servicebrokers.CreateServiceBrokerRequest;
import org.cloudfoundry.client.v3.servicebrokers.DeleteServiceBrokerRequest;
import org.cloudfoundry.client.v3.servicebrokers.GetServiceBrokerRequest;
import org.cloudfoundry.client.v3.servicebrokers.GetServiceBrokerResponse;
import org.cloudfoundry.client.v3.servicebrokers.ListServiceBrokersRequest;
import org.cloudfoundry.client.v3.servicebrokers.ListServiceBrokersResponse;
import org.cloudfoundry.client.v3.servicebrokers.ServiceBrokerResource;
import org.cloudfoundry.client.v3.servicebrokers.ServiceBrokersV3;
import org.cloudfoundry.client.v3.servicebrokers.UpdateServiceBrokerRequest;
import org.cloudfoundry.client.v3.servicebrokers.UpdateServiceBrokerResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServiceBrokersV3
extends AbstractClientV3Operations
implements ServiceBrokersV3 {
    public ReactorServiceBrokersV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<String> create(CreateServiceBrokerRequest request) {
        return this.post(request, builder -> builder.pathSegment(new String[]{"service_brokers"})).checkpoint();
    }

    public Mono<String> delete(DeleteServiceBrokerRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"service_brokers", request.getServiceBrokerId()})).checkpoint();
    }

    public Mono<GetServiceBrokerResponse> get(GetServiceBrokerRequest request) {
        return this.get((Object)request, GetServiceBrokerResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_brokers", request.getServiceBrokerId()})).checkpoint();
    }

    public Mono<ListServiceBrokersResponse> list(ListServiceBrokersRequest request) {
        return this.get((Object)request, ListServiceBrokersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"service_brokers"})).checkpoint();
    }

    public Mono<UpdateServiceBrokerResponse> update(UpdateServiceBrokerRequest request) {
        return this.patchWithResponse(request, ServiceBrokerResource.class, builder -> builder.pathSegment(new String[]{"service_brokers", request.getServiceBrokerId()})).map(responseTuple -> UpdateServiceBrokerResponse.builder().serviceBroker(responseTuple.getBody()).jobId(Optional.ofNullable(ReactorServiceBrokersV3.extractJobId(responseTuple.getResponse()))).build()).checkpoint();
    }
}

