/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.routes;

import java.util.Map;
import org.cloudfoundry.client.v3.routes.CreateRouteRequest;
import org.cloudfoundry.client.v3.routes.CreateRouteResponse;
import org.cloudfoundry.client.v3.routes.DeleteRouteRequest;
import org.cloudfoundry.client.v3.routes.GetRouteRequest;
import org.cloudfoundry.client.v3.routes.GetRouteResponse;
import org.cloudfoundry.client.v3.routes.InsertRouteDestinationsRequest;
import org.cloudfoundry.client.v3.routes.InsertRouteDestinationsResponse;
import org.cloudfoundry.client.v3.routes.ListRouteDestinationsRequest;
import org.cloudfoundry.client.v3.routes.ListRouteDestinationsResponse;
import org.cloudfoundry.client.v3.routes.ListRoutesRequest;
import org.cloudfoundry.client.v3.routes.ListRoutesResponse;
import org.cloudfoundry.client.v3.routes.RemoveRouteDestinationsRequest;
import org.cloudfoundry.client.v3.routes.ReplaceRouteDestinationsRequest;
import org.cloudfoundry.client.v3.routes.ReplaceRouteDestinationsResponse;
import org.cloudfoundry.client.v3.routes.RoutesV3;
import org.cloudfoundry.client.v3.routes.UpdateRouteRequest;
import org.cloudfoundry.client.v3.routes.UpdateRouteResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class ReactorRoutesV3
extends AbstractClientV3Operations
implements RoutesV3 {
    public ReactorRoutesV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CreateRouteResponse> create(CreateRouteRequest request) {
        return this.post(request, CreateRouteResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes"})).checkpoint();
    }

    public Mono<String> delete(DeleteRouteRequest request) {
        return this.delete(request, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }

    public Mono<GetRouteResponse> get(GetRouteRequest request) {
        return this.get((Object)request, GetRouteResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }

    public Mono<InsertRouteDestinationsResponse> insertDestinations(InsertRouteDestinationsRequest request) {
        return this.post(request, InsertRouteDestinationsResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId(), "destinations"})).checkpoint();
    }

    public Mono<ListRoutesResponse> list(ListRoutesRequest request) {
        return this.get((Object)request, ListRoutesResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"routes"})).checkpoint();
    }

    public Mono<ListRouteDestinationsResponse> listDestinations(ListRouteDestinationsRequest request) {
        return this.get((Object)request, ListRouteDestinationsResponse.class, (UriComponentsBuilder uriComponentsBuilder) -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId(), "destinations"})).checkpoint();
    }

    public Mono<Void> removeDestinations(RemoveRouteDestinationsRequest request) {
        return this.delete(request, Void.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId(), "destinations", request.getDestinationId()})).checkpoint();
    }

    public Mono<ReplaceRouteDestinationsResponse> replaceDestinations(ReplaceRouteDestinationsRequest request) {
        return this.patch(request, ReplaceRouteDestinationsResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId(), "destinations"})).checkpoint();
    }

    public Mono<UpdateRouteResponse> update(UpdateRouteRequest request) {
        return this.patch(request, UpdateRouteResponse.class, uriComponentsBuilder -> uriComponentsBuilder.pathSegment(new String[]{"routes", request.getRouteId()})).checkpoint();
    }
}

