/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.packages;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.cloudfoundry.client.v3.packages.CopyPackageRequest;
import org.cloudfoundry.client.v3.packages.CopyPackageResponse;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.DeletePackageRequest;
import org.cloudfoundry.client.v3.packages.DownloadPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.ListPackageDropletsRequest;
import org.cloudfoundry.client.v3.packages.ListPackageDropletsResponse;
import org.cloudfoundry.client.v3.packages.ListPackagesRequest;
import org.cloudfoundry.client.v3.packages.ListPackagesResponse;
import org.cloudfoundry.client.v3.packages.Packages;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.cloudfoundry.util.FileUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;

public final class ReactorPackages
extends AbstractClientV3Operations
implements Packages {
    public ReactorPackages(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CopyPackageResponse> copy(CopyPackageRequest request) {
        return this.post(request, CopyPackageResponse.class, builder -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<CreatePackageResponse> create(CreatePackageRequest request) {
        return this.post(request, CreatePackageResponse.class, builder -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<String> delete(DeletePackageRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId()})).checkpoint();
    }

    public Flux<byte[]> download(DownloadPackageRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "download"}), ByteBufFlux::asByteArray).checkpoint();
    }

    public Mono<GetPackageResponse> get(GetPackageRequest request) {
        return this.get((Object)request, GetPackageResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"packages", request.getPackageId()})).checkpoint();
    }

    public Mono<ListPackagesResponse> list(ListPackagesRequest request) {
        return this.get((Object)request, ListPackagesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"packages"})).checkpoint();
    }

    public Mono<ListPackageDropletsResponse> listDroplets(ListPackageDropletsRequest request) {
        return this.get((Object)request, ListPackageDropletsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "droplets"})).checkpoint();
    }

    public Mono<UploadPackageResponse> upload(UploadPackageRequest request) {
        Path bits = request.getBits();
        if (bits.toFile().isDirectory()) {
            return FileUtils.compress((Path)bits).map(temporaryFile -> UploadPackageRequest.builder().from(request).bits(temporaryFile).build()).flatMap(requestWithTemporaryFile -> this.upload((UploadPackageRequest)requestWithTemporaryFile, () -> {
                try {
                    Files.delete(requestWithTemporaryFile.getBits());
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }));
        }
        return this.upload(request, () -> {});
    }

    private Mono<UploadPackageResponse> upload(UploadPackageRequest request, Runnable onTerminate) {
        return this.post(request, UploadPackageResponse.class, builder -> builder.pathSegment(new String[]{"packages", request.getPackageId(), "upload"}), outbound -> this.upload(request.getBits(), (MultipartHttpClientRequest)outbound), onTerminate).checkpoint();
    }

    private void upload(Path bits, MultipartHttpClientRequest r) {
        r.addPart(part -> part.setName("bits").setContentType("application/zip").sendFile(bits)).done();
    }
}

