/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpStatusClass;
import java.util.Map;
import java.util.function.Function;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.client.v2.ClientV2Exception;
import org.cloudfoundry.client.v3.ClientV3Exception;
import org.cloudfoundry.client.v3.Errors;
import org.cloudfoundry.uaa.UaaException;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientResponse;

public final class ErrorPayloadMapper {
    public static Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> clientV2(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMapper.mapToError((statusCode, payload) -> {
            Map map = (Map)objectMapper.readValue(payload, Map.class);
            Integer code = (Integer)map.get("code");
            String description = (String)map.get("description");
            String errorCode = (String)map.get("error_code");
            return new ClientV2Exception(statusCode, code, description, errorCode);
        }));
    }

    public static Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> clientV3(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMapper.mapToError((statusCode, payload) -> {
            Errors errors = (Errors)objectMapper.readValue(payload, Errors.class);
            return new ClientV3Exception(statusCode, errors.getErrors());
        }));
    }

    public static Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> fallback() {
        return inbound -> inbound.flatMap(response -> {
            if (!ErrorPayloadMapper.isError(response)) {
                return Mono.just((Object)response);
            }
            return response.receive().aggregate().asString().flatMap(payload -> Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.status().code()), payload)));
        });
    }

    public static Function<Mono<HttpClientResponse>, Mono<HttpClientResponse>> uaa(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMapper.mapToError((statusCode, payload) -> {
            Map map = (Map)objectMapper.readValue(payload, Map.class);
            String error = (String)map.get("error");
            String errorDescription = (String)map.get("error_description");
            return new UaaException(statusCode, error, errorDescription);
        }));
    }

    private static boolean isError(HttpClientResponse response) {
        HttpStatusClass statusClass = response.status().codeClass();
        return statusClass == HttpStatusClass.CLIENT_ERROR || statusClass == HttpStatusClass.SERVER_ERROR;
    }

    private static Function<HttpClientResponse, Mono<HttpClientResponse>> mapToError(ExceptionGenerator exceptionGenerator) {
        return response -> {
            if (!ErrorPayloadMapper.isError(response)) {
                return Mono.just((Object)response);
            }
            return response.receive().aggregate().asString().switchIfEmpty(Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.status().code())))).flatMap(payload -> {
                try {
                    return Mono.error((Throwable)exceptionGenerator.apply(response.status().code(), (String)payload));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.status().code()), payload));
                }
            });
        };
    }

    @FunctionalInterface
    private static interface ExceptionGenerator {
        public RuntimeException apply(Integer var1, String var2) throws Exception;
    }
}

