/*
 * Decompiled with CFR 0.152.
 */
package clojure.data.int_map;

import clojure.data.int_map.INode;
import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.MapEntry;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;

public class Nodes {
    private static final byte[] deBruijnIndex = new byte[]{0, 1, 2, 53, 3, 7, 54, 27, 4, 38, 41, 8, 34, 55, 48, 28, 62, 5, 39, 46, 44, 42, 22, 9, 24, 35, 59, 56, 49, 18, 29, 11, 63, 52, 6, 26, 37, 40, 33, 47, 61, 45, 43, 21, 23, 58, 17, 10, 51, 25, 36, 32, 60, 20, 57, 16, 50, 31, 19, 15, 30, 14, 13, 12};

    public static IFn invert(IFn f) {
        if (f instanceof InvertFn) {
            return ((InvertFn)f).f;
        }
        return new InvertFn(f);
    }

    public static long lowestBit(long n) {
        return n & -n;
    }

    public static int bitLog2(long n) {
        return deBruijnIndex[0xFF & (int)(n * 157587932685088877L >>> 58)];
    }

    public static int offset(long a, long b) {
        return Nodes.bitLog2(Nodes.highestBit(a ^ b, 1L)) & 0xFFFFFFFC;
    }

    public static long highestBit(long n, long estimate) {
        long x = n & (estimate - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        long m;
        while (x != (m = Nodes.lowestBit(x))) {
            x -= m;
        }
        return m;
    }

    public static class Empty
    implements INode {
        public static Empty EMPTY = new Empty();

        Empty() {
        }

        @Override
        public INode range(long min, long max) {
            return this;
        }

        @Override
        public Iterator iterator(INode.IterationType type, boolean reverse) {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object reduce(IFn f, Object init) {
            return init;
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            return init;
        }

        @Override
        public Object fold(long n, IFn combiner, IFn reducer, IFn fjtask, IFn fjfork, IFn fjjoin) {
            return combiner.invoke();
        }

        @Override
        public long count() {
            return 0L;
        }

        @Override
        public INode merge(INode node, long epoch, IFn f) {
            return node;
        }

        @Override
        public INode assoc(long k, long epoch, IFn f, Object v) {
            return new Leaf(k, v);
        }

        @Override
        public INode dissoc(long k, long epoch) {
            return this;
        }

        @Override
        public INode update(long k, long epoch, IFn f) {
            return new Leaf(k, f.invoke(null));
        }

        @Override
        public Object get(long k, Object defaultVal) {
            return defaultVal;
        }
    }

    public static class Leaf
    implements INode {
        public final long key;
        public final Object value;

        public Leaf(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Iterator iterator(final INode.IterationType type, boolean reverse) {
            return new Iterator(){
                boolean iterated = false;

                @Override
                public boolean hasNext() {
                    return !this.iterated;
                }

                public Object next() {
                    if (this.iterated) {
                        throw new NoSuchElementException();
                    }
                    this.iterated = true;
                    switch (type) {
                        case KEYS: {
                            return key;
                        }
                        case VALS: {
                            return value;
                        }
                        case ENTRIES: {
                            return new MapEntry((Object)key, value);
                        }
                    }
                    throw new IllegalStateException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public INode range(long min, long max) {
            return min <= this.key && this.key <= max ? this : null;
        }

        @Override
        public Object reduce(IFn f, Object init) {
            return f.invoke(init, (Object)new MapEntry((Object)this.key, this.value));
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            return f.invoke(init, (Object)this.key, this.value);
        }

        @Override
        public Object fold(long n, IFn combiner, IFn reducer, IFn fjtask, IFn fjfork, IFn fjjoin) {
            return this.kvreduce(reducer, combiner.invoke());
        }

        @Override
        public long count() {
            return 1L;
        }

        @Override
        public INode merge(INode node, long epoch, IFn f) {
            return node.assoc(this.key, epoch, Nodes.invert(f), this.value);
        }

        @Override
        public INode assoc(long k, long epoch, IFn f, Object v) {
            if (k == this.key) {
                v = f == null ? v : f.invoke(this.value, v);
                return new Leaf(k, v);
            }
            if (this.key < 0L && k >= 0L) {
                return new BinaryBranch(this, new Leaf(k, v));
            }
            if (k < 0L && this.key >= 0L) {
                return new BinaryBranch(new Leaf(k, v), this);
            }
            return new Branch(k, Nodes.offset(k, this.key), epoch, new INode[16]).assoc(this.key, epoch, f, this.value).assoc(k, epoch, f, v);
        }

        @Override
        public INode dissoc(long k, long epoch) {
            if (this.key == k) {
                return null;
            }
            return this;
        }

        @Override
        public INode update(long k, long epoch, IFn f) {
            if (k == this.key) {
                Object v = f.invoke(this.value);
                return new Leaf(k, v);
            }
            return this.assoc(k, epoch, null, f.invoke(null));
        }

        @Override
        public Object get(long k, Object defaultVal) {
            if (k == this.key) {
                return this.value;
            }
            return defaultVal;
        }
    }

    public static class Branch
    implements INode {
        public final long prefix;
        public final long mask;
        public final long epoch;
        public final int offset;
        long count;
        public final INode[] children;

        public Branch(long prefix, int offset, long epoch, long count, INode[] children) {
            this.prefix = prefix;
            this.offset = offset;
            this.epoch = epoch;
            this.mask = 15L << offset;
            this.count = count;
            this.children = children;
        }

        public Branch(long prefix, int offset, long epoch, INode[] children) {
            this.prefix = prefix;
            this.offset = offset;
            this.epoch = epoch;
            this.mask = 15L << offset;
            this.count = -1L;
            this.children = children;
        }

        public int indexOf(long key) {
            return (int)((key & this.mask) >>> this.offset);
        }

        private INode[] arraycopy() {
            INode[] copy = new INode[16];
            System.arraycopy(this.children, 0, copy, 0, 16);
            return copy;
        }

        private static int overlap(long min0, long max0, long min1, long max1) {
            if (min0 <= min1 && max1 <= max0) {
                return 2;
            }
            if (min0 <= max1 && min1 <= max0) {
                return 1;
            }
            return 0;
        }

        @Override
        public INode range(long min, long max) {
            long nodeMask = this.offset < 60 ? (1L << this.offset + 4) - 1L : Long.MAX_VALUE;
            long nodeMin = this.prefix & (nodeMask ^ 0xFFFFFFFFFFFFFFFFL);
            long nodeMax = this.prefix | nodeMask;
            switch (Branch.overlap(min, max, nodeMin, nodeMax)) {
                case 2: {
                    return this;
                }
                case 0: {
                    return null;
                }
            }
            INode[] children = null;
            boolean atLeastOneDropped = false;
            int minI = min <= nodeMin ? -1 : this.indexOf(Math.min(nodeMax, min));
            int maxI = max >= nodeMax ? 16 : this.indexOf(Math.max(nodeMin, max));
            INode onlyChild = null;
            int numChildren = 0;
            for (int i = 0; i < 16; ++i) {
                INode child;
                INode c = this.children[i];
                if (c == null) continue;
                INode iNode = i < minI || maxI < i ? null : (child = minI < i && i < maxI ? c : c.range(min, max));
                if (children != null) {
                    children[i] = child;
                } else if (child == null) {
                    if (numChildren != 0) {
                        children = (INode[])this.children.clone();
                        children[i] = null;
                    } else {
                        atLeastOneDropped = true;
                    }
                } else if (child != c) {
                    children = numChildren != 0 ? (INode[])this.children.clone() : new INode[16];
                    children[i] = child;
                } else if (atLeastOneDropped) {
                    children = new INode[16];
                    children[i] = child;
                }
                if (child == null) continue;
                ++numChildren;
                onlyChild = child;
            }
            return numChildren == 0 ? null : (numChildren == 1 ? onlyChild : (children == null ? this : new Branch(this.prefix, this.offset, this.epoch, children)));
        }

        @Override
        public Iterator iterator(final INode.IterationType type, final boolean reverse) {
            return new Iterator(){
                private byte idx;
                private Iterator iterator;
                {
                    this.idx = (byte)(reverse ? 16 : -1);
                    this.iterator = null;
                }

                private void advanceToNext() {
                    while (reverse ? (this.idx = (byte)(this.idx - 1)) >= 0 : (this.idx = (byte)(this.idx + 1)) < 16) {
                        INode c = children[this.idx];
                        if (c == null) continue;
                        this.iterator = children[this.idx].iterator(type, reverse);
                        if (!this.iterator.hasNext()) continue;
                        return;
                    }
                    this.iterator = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return true;
                    }
                    this.advanceToNext();
                    return this.iterator != null;
                }

                public Object next() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    this.advanceToNext();
                    if (this.iterator != null) {
                        return this.iterator.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object get(long k, Object defaultVal) {
            INode n = this.children[this.indexOf(k)];
            return n == null ? defaultVal : n.get(k, defaultVal);
        }

        @Override
        public long count() {
            int count = 0;
            for (int i = 0; i < 16; ++i) {
                INode n = this.children[i];
                if (n == null) continue;
                count = (int)((long)count + n.count());
            }
            this.count = count;
            return count;
        }

        @Override
        public INode merge(INode node, long epoch, IFn f) {
            if (node instanceof Branch) {
                Branch branch = (Branch)node;
                int offsetPrime = Nodes.offset(this.prefix, branch.prefix);
                if (branch.prefix < 0L && this.prefix >= 0L) {
                    return new BinaryBranch(branch, this);
                }
                if (branch.prefix >= 0L && this.prefix < 0L) {
                    return new BinaryBranch(this, branch);
                }
                if (offsetPrime > this.offset && offsetPrime > branch.offset) {
                    return new Branch(this.prefix, Nodes.offset(this.prefix, branch.prefix), epoch, new INode[16]).merge(this, epoch, f).merge(node, epoch, f);
                }
                if (this.offset > branch.offset) {
                    int idx = this.indexOf(branch.prefix);
                    INode[] children = this.arraycopy();
                    INode n = children[idx];
                    INode iNode = n != null ? n.merge(node, epoch, f) : node;
                    children[idx] = iNode;
                    return new Branch(this.prefix, this.offset, epoch, children);
                }
                if (this.offset < branch.offset) {
                    return branch.merge(this, epoch, Nodes.invert(f));
                }
                INode[] children = new INode[16];
                INode[] branchChildren = branch.children;
                int offset = this.offset;
                for (int i = 0; i < 16; ++i) {
                    INode n = this.children[i];
                    INode nPrime = branchChildren[i];
                    children[i] = n == null ? nPrime : (nPrime == null ? n : n.merge(nPrime, epoch, f));
                }
                return new Branch(this.prefix, offset, epoch, children);
            }
            return node.merge(this, epoch, Nodes.invert(f));
        }

        @Override
        public INode assoc(long k, long epoch, IFn f, Object v) {
            int offsetPrime = Nodes.offset(k, this.prefix);
            if (this.prefix < 0L && k >= 0L) {
                return new BinaryBranch(this, new Leaf(k, v));
            }
            if (k < 0L && this.prefix >= 0L) {
                return new BinaryBranch(new Leaf(k, v), this);
            }
            if (offsetPrime > this.offset) {
                return new Branch(k, offsetPrime, epoch, new INode[16]).merge(this, epoch, null).assoc(k, epoch, f, v);
            }
            int idx = this.indexOf(k);
            INode n = this.children[idx];
            if (n == null) {
                if (epoch == this.epoch) {
                    this.children[idx] = new Leaf(k, v);
                    this.count = -1L;
                    return this;
                }
                INode[] children = this.arraycopy();
                children[idx] = new Leaf(k, v);
                return new Branch(this.prefix, this.offset, epoch, this.count, children);
            }
            INode nPrime = n.assoc(k, epoch, f, v);
            if (nPrime == n) {
                this.count = -1L;
                return this;
            }
            INode[] children = this.arraycopy();
            children[idx] = nPrime;
            return new Branch(this.prefix, this.offset, epoch, this.count, children);
        }

        @Override
        public INode dissoc(long k, long epoch) {
            int idx = this.indexOf(k);
            INode n = this.children[idx];
            if (n == null) {
                return this;
            }
            INode nPrime = n.dissoc(k, epoch);
            if (nPrime == n) {
                this.count = -1L;
                return this;
            }
            INode[] children = this.arraycopy();
            children[idx] = nPrime;
            for (int i = 0; i < 16; ++i) {
                if (children[i] == null) continue;
                return new Branch(this.prefix, this.offset, epoch, this.count, children);
            }
            return null;
        }

        @Override
        public INode update(long k, long epoch, IFn f) {
            int offsetPrime = Nodes.offset(k, this.prefix);
            if (this.prefix < 0L && k >= 0L) {
                return new BinaryBranch(this, new Leaf(k, f.invoke(null)));
            }
            if (k < 0L && this.prefix >= 0L) {
                return new BinaryBranch(new Leaf(k, f.invoke(null)), this);
            }
            if (offsetPrime > this.offset) {
                return new Branch(k, offsetPrime, epoch, new INode[16]).merge(this, epoch, null).update(k, epoch, f);
            }
            int idx = this.indexOf(k);
            INode n = this.children[idx];
            if (n == null) {
                if (epoch == this.epoch) {
                    this.children[idx] = new Leaf(k, f.invoke(null));
                    this.count = -1L;
                    return this;
                }
                INode[] children = this.arraycopy();
                children[idx] = new Leaf(k, f.invoke(null));
                return new Branch(this.prefix, this.offset, epoch, this.count, children);
            }
            INode nPrime = n.update(k, epoch, f);
            if (nPrime == n) {
                this.count = -1L;
                return this;
            }
            INode[] children = this.arraycopy();
            children[idx] = nPrime;
            return new Branch(this.prefix, this.offset, epoch, this.count, children);
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            for (int i = 0; i < 16; ++i) {
                INode n = this.children[i];
                if (n != null) {
                    init = n.kvreduce(f, init);
                }
                if (RT.isReduced((Object)init)) break;
            }
            return init;
        }

        @Override
        public Object reduce(IFn f, Object init) {
            for (int i = 0; i < 16; ++i) {
                INode n = this.children[i];
                if (n != null) {
                    init = n.reduce(f, init);
                }
                if (RT.isReduced((Object)init)) break;
            }
            return init;
        }

        public static Object foldTasks(List<Callable> tasks, final IFn combiner, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
            if (tasks.isEmpty()) {
                return combiner.invoke();
            }
            if (tasks.size() == 1) {
                try {
                    return tasks.get(0).call();
                }
                catch (Exception e) {
                    throw Util.sneakyThrow((Throwable)e);
                }
            }
            List<Callable> t1 = tasks.subList(0, tasks.size() / 2);
            final List<Callable> t2 = tasks.subList(tasks.size() / 2, tasks.size());
            Object forked = fjfork.invoke(fjtask.invoke((Object)new Callable(){

                public Object call() throws Exception {
                    return Branch.foldTasks(t2, combiner, fjtask, fjfork, fjjoin);
                }
            }));
            return combiner.invoke(Branch.foldTasks(t1, combiner, fjtask, fjfork, fjjoin), fjjoin.invoke(forked));
        }

        @Override
        public Object fold(final long n, final IFn combiner, final IFn reducer, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
            if (n > this.count()) {
                ArrayList<Callable> tasks = new ArrayList<Callable>();
                for (int i = 0; i < 16; ++i) {
                    final INode node = this.children[i];
                    if (node == null) continue;
                    tasks.add(new Callable(){

                        public Object call() throws Exception {
                            return node.fold(n, combiner, reducer, fjtask, fjfork, fjjoin);
                        }
                    });
                }
                return Branch.foldTasks(tasks, combiner, fjtask, fjfork, fjjoin);
            }
            return this.kvreduce(reducer, combiner.invoke());
        }
    }

    public static class BinaryBranch
    implements INode {
        public INode a;
        public INode b;

        public BinaryBranch(INode a, INode b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public long count() {
            return this.a.count() + this.b.count();
        }

        @Override
        public Iterator iterator(final INode.IterationType type, final boolean reverse) {
            return new Iterator(){
                boolean first = true;
                Iterator iterator;
                {
                    this.iterator = reverse ? b.iterator(type, reverse) : a.iterator(type, reverse);
                }

                @Override
                public boolean hasNext() {
                    if (this.iterator.hasNext()) {
                        return true;
                    }
                    if (this.first) {
                        this.first = false;
                        this.iterator = reverse ? a.iterator(type, reverse) : b.iterator(type, reverse);
                    }
                    return this.iterator.hasNext();
                }

                public Object next() {
                    if (this.hasNext()) {
                        return this.iterator.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public INode range(long min, long max) {
            if (max < 0L) {
                return this.a.range(min, max);
            }
            if (min >= 0L) {
                return this.b.range(min, max);
            }
            INode aPrime = this.a.range(min, max);
            INode bPrime = this.b.range(min, max);
            if (aPrime == null && bPrime == null) {
                return Empty.EMPTY;
            }
            if (aPrime == null) {
                return bPrime;
            }
            if (bPrime == null) {
                return aPrime;
            }
            return new BinaryBranch(aPrime, bPrime);
        }

        @Override
        public INode merge(INode node, long epoch, IFn f) {
            if (node instanceof BinaryBranch) {
                BinaryBranch bin = (BinaryBranch)node;
                return new BinaryBranch(this.a.merge(bin.a, epoch, f), this.b.merge(bin.b, epoch, f));
            }
            if (node instanceof Branch) {
                Branch branch = (Branch)node;
                return branch.prefix < 0L ? new BinaryBranch(this.a.merge(node, epoch, f), this.b) : new BinaryBranch(this.a, this.b.merge(node, epoch, f));
            }
            return node.merge(this, epoch, Nodes.invert(f));
        }

        @Override
        public INode assoc(long k, long epoch, IFn f, Object v) {
            if (k < 0L) {
                INode aPrime = this.a.assoc(k, epoch, f, v);
                return this.a == aPrime ? this : new BinaryBranch(aPrime, this.b);
            }
            INode bPrime = this.b.assoc(k, epoch, f, v);
            return this.b == bPrime ? this : new BinaryBranch(this.a, bPrime);
        }

        @Override
        public INode dissoc(long k, long epoch) {
            if (k < 0L) {
                INode aPrime = this.a.dissoc(k, epoch);
                return aPrime == null ? this.b : (this.a == aPrime ? this : new BinaryBranch(aPrime, this.b));
            }
            INode bPrime = this.b.dissoc(k, epoch);
            return bPrime == null ? this.a : (this.b == bPrime ? this : new BinaryBranch(this.a, bPrime));
        }

        @Override
        public INode update(long k, long epoch, IFn f) {
            if (k < 0L) {
                INode aPrime = this.a.update(k, epoch, f);
                return this.a == aPrime ? this : new BinaryBranch(aPrime, this.b);
            }
            INode bPrime = this.b.update(k, epoch, f);
            return this.b == bPrime ? this : new BinaryBranch(this.a, bPrime);
        }

        @Override
        public Object get(long k, Object defaultVal) {
            return k < 0L ? this.a.get(k, defaultVal) : this.b.get(k, defaultVal);
        }

        @Override
        public Object kvreduce(IFn f, Object init) {
            if (RT.isReduced((Object)(init = this.a.kvreduce(f, init)))) {
                return init;
            }
            return this.b.kvreduce(f, init);
        }

        @Override
        public Object reduce(IFn f, Object init) {
            if (RT.isReduced((Object)(init = this.a.reduce(f, init)))) {
                return init;
            }
            return this.b.reduce(f, init);
        }

        @Override
        public Object fold(final long n, final IFn combiner, final IFn reducer, final IFn fjtask, final IFn fjfork, final IFn fjjoin) {
            if (this.count() > n) {
                Callable forked = new Callable(){

                    public Object call() throws Exception {
                        return b.fold(n, combiner, reducer, fjtask, fjfork, fjjoin);
                    }
                };
                return combiner.invoke(this.a.fold(n, combiner, reducer, fjtask, fjfork, fjjoin), fjjoin.invoke(fjfork.invoke(fjtask.invoke((Object)forked))));
            }
            return this.kvreduce(reducer, combiner.invoke());
        }
    }

    static class InvertFn
    extends AFn {
        IFn f;

        public InvertFn(IFn f) {
            this.f = f;
        }

        public Object invoke(Object x, Object y) {
            return this.f.invoke(y, x);
        }
    }
}

