/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TypecheckResult;
import org.checkerframework.javacutil.PluginUtil;
import org.junit.Assert;

public class TestUtilities {
    public static final boolean IS_AT_LEAST_9_JVM;

    public static List<File> findNestedJavaTestFiles(String ... dirNames) {
        return TestUtilities.findRelativeNestedJavaFiles(new File("tests"), dirNames);
    }

    public static List<File> findRelativeNestedJavaFiles(String parent, String ... dirNames) {
        return TestUtilities.findRelativeNestedJavaFiles(new File(parent), dirNames);
    }

    public static List<File> findRelativeNestedJavaFiles(File parent, String ... dirNames) {
        File[] dirs = new File[dirNames.length];
        int i = 0;
        for (String dirName : dirNames) {
            dirs[i] = new File(parent, dirName);
            ++i;
        }
        return TestUtilities.getJavaFilesAsArgumentList(dirs);
    }

    public static List<List<File>> findJavaFilesPerDirectory(File parent, String ... dirNames) {
        ArrayList<List<File>> filesPerDirectory = new ArrayList<List<File>>();
        for (String dirName : dirNames) {
            File dir = new File(parent, dirName);
            if (!dir.isDirectory()) continue;
            filesPerDirectory.addAll(TestUtilities.findJavaTestFilesInDirectory(dir));
        }
        return filesPerDirectory;
    }

    private static List<List<File>> findJavaTestFilesInDirectory(File dir) {
        assert (dir.isDirectory());
        ArrayList<List<File>> fileGroupedByDirectory = new ArrayList<List<File>>();
        ArrayList<File> fileInDir = new ArrayList<File>();
        fileGroupedByDirectory.add(fileInDir);
        for (String fileName : dir.list()) {
            File file = new File(dir, fileName);
            if (file.isDirectory()) {
                fileGroupedByDirectory.addAll(TestUtilities.findJavaTestFilesInDirectory(file));
                continue;
            }
            if (!TestUtilities.isJavaTestFile(file)) continue;
            fileInDir.add(file);
        }
        if (fileInDir.isEmpty()) {
            fileGroupedByDirectory.remove(fileInDir);
        }
        return fileGroupedByDirectory;
    }

    public static List<Object[]> findFilesInParent(File parent, String ... fileNames) {
        ArrayList<Object[]> files = new ArrayList<Object[]>();
        for (String fileName : fileNames) {
            files.add(new Object[]{new File(parent, fileName)});
        }
        return files;
    }

    public static List<File> getJavaFilesAsArgumentList(File ... dirs) {
        ArrayList<File> arguments = new ArrayList<File>();
        for (File dir : dirs) {
            List<File> javaFiles = TestUtilities.deeplyEnclosedJavaTestFiles(dir);
            for (File javaFile : javaFiles) {
                arguments.add(javaFile);
            }
        }
        return arguments;
    }

    public static List<File> deeplyEnclosedJavaTestFiles(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException("directory does not exist: " + directory + " " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("found file instead of directory: " + directory);
        }
        ArrayList<File> javaFiles = new ArrayList<File>();
        File[] in = directory.listFiles();
        Arrays.sort(in, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : in) {
            if (file.isDirectory()) {
                javaFiles.addAll(TestUtilities.deeplyEnclosedJavaTestFiles(file));
                continue;
            }
            if (!TestUtilities.isJavaTestFile(file)) continue;
            javaFiles.add(file);
        }
        return javaFiles;
    }

    public static boolean isJavaFile(File file) {
        return file.isFile() && file.getName().endsWith(".java");
    }

    public static boolean isJavaTestFile(File file) {
        if (!TestUtilities.isJavaFile(file)) {
            return false;
        }
        Scanner in = null;
        try {
            in = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        while (in.hasNext()) {
            String nextLine = in.nextLine();
            if (!nextLine.contains("@skip-test") && (IS_AT_LEAST_9_JVM || !nextLine.contains("@below-java9-jdk-skip-test"))) continue;
            in.close();
            return false;
        }
        in.close();
        return true;
    }

    public static String diagnosticToString(Diagnostic<? extends JavaFileObject> diagnostic, boolean usingAnomsgtxt) {
        String result = diagnostic.toString().trim();
        if (result.contains("uses unchecked or unsafe operations.") || result.contains("Recompile with -Xlint:unchecked for details.") || result.endsWith(" declares unsafe vararg methods.") || result.contains("Recompile with -Xlint:varargs for details.")) {
            return null;
        }
        if (usingAnomsgtxt && !result.contains("unexpected Throwable")) {
            String firstLine = result.contains("\n") ? result.substring(0, result.indexOf(10)) : result;
            if (firstLine.contains(".java:")) {
                firstLine = firstLine.substring(firstLine.indexOf(".java:") + 5).trim();
            }
            result = firstLine;
        }
        return result;
    }

    public static Set<String> diagnosticsToStrings(Iterable<Diagnostic<? extends JavaFileObject>> actualDiagnostics, boolean usingAnomsgtxt) {
        LinkedHashSet<String> actualDiagnosticsStr = new LinkedHashSet<String>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : actualDiagnostics) {
            String diagnosticStr = TestUtilities.diagnosticToString(diagnostic, usingAnomsgtxt);
            if (diagnosticStr == null) continue;
            actualDiagnosticsStr.add(diagnosticStr);
        }
        return actualDiagnosticsStr;
    }

    public static String summarizeSourceFiles(List<File> javaFiles) {
        StringBuilder listStrBuilder = new StringBuilder();
        boolean first = true;
        for (File file : javaFiles) {
            if (first) {
                first = false;
            } else {
                listStrBuilder.append(", ");
            }
            listStrBuilder.append(file.getAbsolutePath());
        }
        return listStrBuilder.toString();
    }

    public static File getTestFile(String fileRelativeToTestsDir) {
        return new File("tests", fileRelativeToTestsDir);
    }

    public static File findComparisonFile(File testFile) {
        File comparisonFile = new File(testFile.getParent(), testFile.getName().replace(".java", ".out"));
        return comparisonFile;
    }

    public static List<String> optionMapToList(Map<String, String> options) {
        ArrayList<String> optionList = new ArrayList<String>(options.size() * 2);
        for (Map.Entry<String, String> opt : options.entrySet()) {
            optionList.add(opt.getKey());
            if (opt.getValue() == null) continue;
            optionList.add(opt.getValue());
        }
        return optionList;
    }

    public static void writeLines(File file, Iterable<?> lines) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
            for (Object next : lines) {
                if (next == null) {
                    bw.write("<null>");
                } else {
                    bw.write(next.toString());
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    public static void writeDiagnostics(File file, File testFile, List<String> expected, List<String> actual, List<String> unexpected, List<String> missing, boolean usingNoMsgText, boolean testFailed) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
            bw.write("File: " + testFile.getAbsolutePath() + "\n");
            bw.write("TestFailed: " + testFailed + "\n");
            bw.write("Using nomsgtxt: " + usingNoMsgText + "\n");
            bw.write("#Missing: " + missing.size() + "      #Unexpected: " + unexpected.size() + "\n");
            bw.write("Expected:\n");
            bw.write(String.join((CharSequence)"\n", expected));
            bw.newLine();
            bw.write("Actual:\n");
            bw.write(String.join((CharSequence)"\n", actual));
            bw.newLine();
            bw.write("Missing:\n");
            bw.write(String.join((CharSequence)"\n", missing));
            bw.newLine();
            bw.write("Unexpected:\n");
            bw.write(String.join((CharSequence)"\n", unexpected));
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeTestConfiguration(File file, TestConfiguration config) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
            bw.write(config.toString());
            bw.newLine();
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJavacArguments(File file, Iterable<? extends JavaFileObject> files, Iterable<String> options, Iterable<String> processors) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
            bw.write("Files:\n");
            for (JavaFileObject javaFileObject : files) {
                bw.write("    " + javaFileObject.getName());
                bw.newLine();
            }
            bw.newLine();
            bw.write("Options:\n");
            for (String string : options) {
                bw.write("    " + string);
                bw.newLine();
            }
            bw.newLine();
            bw.write("Processors:\n");
            for (String string : processors) {
                bw.write("    " + string);
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertResultsAreValid(TypecheckResult testResult) {
        if (testResult.didTestFail()) {
            Assert.fail((String)testResult.summarize());
        }
    }

    public static void ensureDirectoryExists(File path) {
        if (!path.exists() && !path.mkdirs()) {
            throw new RuntimeException("Could not make directory: " + path.getAbsolutePath());
        }
    }

    public static boolean testBooleanProperty(String propName) {
        return TestUtilities.testBooleanProperty(propName, false);
    }

    public static boolean testBooleanProperty(String propName, boolean defaultValue) {
        return PluginUtil.getBooleanSystemProperty((String)propName, (boolean)defaultValue);
    }

    public static boolean getShouldEmitDebugInfo() {
        return PluginUtil.getBooleanSystemProperty((String)"emit.test.debug");
    }

    static {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        compiler.run(null, null, err, "-version");
        IS_AT_LEAST_9_JVM = PluginUtil.getJreVersion() >= 1.9;
    }
}

