/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.JapaneseImperialCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import jdk.Profile+Annotation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import sun.util.BuddhistCalendar;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int ERA = 0;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int YEAR = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MONTH = 2;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int WEEK_OF_YEAR = 3;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int WEEK_OF_MONTH = 4;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DATE = 5;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DAY_OF_MONTH = 5;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DAY_OF_YEAR = 6;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DAY_OF_WEEK = 7;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DAY_OF_WEEK_IN_MONTH = 8;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int AM_PM = 9;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int HOUR = 10;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int HOUR_OF_DAY = 11;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MINUTE = 12;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int SECOND = 13;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MILLISECOND = 14;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int ZONE_OFFSET = 15;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DST_OFFSET = 16;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int FIELD_COUNT = 17;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int SUNDAY = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MONDAY = 2;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int TUESDAY = 3;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int WEDNESDAY = 4;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int THURSDAY = 5;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int FRIDAY = 6;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int SATURDAY = 7;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int JANUARY = 0;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int FEBRUARY = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MARCH = 2;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int APRIL = 3;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MAY = 4;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int JUNE = 5;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int JULY = 6;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int AUGUST = 7;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int SEPTEMBER = 8;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int OCTOBER = 9;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int NOVEMBER = 10;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DECEMBER = 11;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int UNDECIMBER = 12;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int AM = 0;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int PM = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int ALL_STYLES = 0;
    static final int STANDALONE_MASK = 32768;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int SHORT = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int LONG = 2;
    public static final int NARROW_FORMAT = 4;
    public static final int NARROW_STANDALONE = 32772;
    public static final int SHORT_FORMAT = 1;
    public static final int LONG_FORMAT = 2;
    public static final int SHORT_STANDALONE = 32769;
    public static final int LONG_STANDALONE = 32770;
    protected int[] fields;
    protected boolean[] isSet;
    private transient int[] stamp;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient;
    private TimeZone zone;
    private transient boolean sharedZone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static final ConcurrentMap<Locale, int[]> cachedLocaleData;
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    static final int ALL_FIELDS = 131071;
    private int nextStamp;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream;
    static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = -1807547505821590642L;
    static final int ERA_MASK = 1;
    static final int YEAR_MASK = 2;
    static final int MONTH_MASK = 4;
    static final int WEEK_OF_YEAR_MASK = 8;
    static final int WEEK_OF_MONTH_MASK = 16;
    static final int DAY_OF_MONTH_MASK = 32;
    static final int DATE_MASK = 32;
    static final int DAY_OF_YEAR_MASK = 64;
    static final int DAY_OF_WEEK_MASK = 128;
    static final int DAY_OF_WEEK_IN_MONTH_MASK = 256;
    static final int AM_PM_MASK = 512;
    static final int HOUR_MASK = 1024;
    static final int HOUR_OF_DAY_MASK = 2048;
    static final int MINUTE_MASK = 4096;
    static final int SECOND_MASK = 8192;
    static final int MILLISECOND_MASK = 16384;
    static final int ZONE_OFFSET_MASK = 32768;
    static final int DST_OFFSET_MASK = 65536;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] FIELD_NAME;

    @FromByteCode
    @FromByteCode
    protected Calendar();

    protected Calendar(TimeZone var1, Locale var2);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Calendar getInstance();

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy TimeZone var0);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Locale var0);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy TimeZone var0, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Locale var1);

    private static Calendar createCalendar(TimeZone var0, Locale var1);

    @FromByteCode
    @FromByteCode
    public static synchronized @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Locale @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] getAvailableLocales();

    protected abstract void computeTime();

    protected abstract void computeFields();

    @FromByteCode
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Date getTime();

    @FromByteCode
    @FromByteCode
    public final void setTime(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Date var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long getTimeInMillis();

    @FromByteCode
    @FromByteCode
    public void setTimeInMillis(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int get(@GuardSatisfied Calendar this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    protected final int internalGet(int var1);

    final void internalSet(int var1, int var2);

    @FromByteCode
    @FromByteCode
    public void set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public final void set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var3);

    @FromByteCode
    @FromByteCode
    public final void set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var3, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var4, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var5);

    @FromByteCode
    @FromByteCode
    public final void set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var3, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var4, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var5, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var6);

    @FromByteCode
    @FromByteCode
    public final void clear();

    @FromByteCode
    @FromByteCode
    public final void clear(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isSet(@GuardSatisfied Calendar this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy String getDisplayName(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Locale var3);

    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Map<@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Integer> getDisplayNames(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Locale var3);

    private Map<String, Integer> getDisplayNamesImpl(int var1, int var2, Locale var3);

    boolean checkDisplayNameParams(int var1, int var2, int var3, int var4, Locale var5, int var6);

    private String[] getFieldStrings(int var1, int var2, DateFormatSymbols var3);

    protected void complete();

    final boolean isExternallySet(int var1);

    final int getSetStateFields();

    final void setFieldsComputed(int var1);

    final void setFieldsNormalized(int var1);

    final boolean isPartiallyNormalized();

    final boolean isFullyNormalized();

    final void setUnnormalized();

    static boolean isFieldSet(int var0, int var1);

    final int selectFields();

    int getBaseStyle(int var1);

    boolean isStandaloneStyle(int var1);

    boolean isNarrowStyle(int var1);

    private static int aggregateStamp(int var0, int var1);

    public static Set<String> getAvailableCalendarTypes();

    public String getCalendarType();

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean equals(@GuardSatisfied Calendar this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int hashCode(@GuardSatisfied Calendar this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean before(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean after(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int compareTo(@GuardSatisfied Calendar this, @UnknownKeyFor @NonNull @Initialized @GuardSatisfied @LockPossiblyHeld Calendar var1);

    @FromByteCode
    @FromByteCode
    public abstract void add(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public abstract void roll(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var2);

    @FromByteCode
    @FromByteCode
    public void roll(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public void setTimeZone(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy TimeZone var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy TimeZone getTimeZone();

    TimeZone getZone();

    void setZoneShared(boolean var1);

    @FromByteCode
    @FromByteCode
    public void setLenient(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isLenient(@GuardSatisfied Calendar this);

    @FromByteCode
    @FromByteCode
    public void setFirstDayOfWeek(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getFirstDayOfWeek();

    @FromByteCode
    @FromByteCode
    public void setMinimalDaysInFirstWeek(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getMinimalDaysInFirstWeek();

    public boolean isWeekDateSupported();

    public int getWeekYear();

    public void setWeekDate(int var1, int var2, int var3);

    public int getWeeksInWeekYear();

    @FromByteCode
    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getMinimum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getMaximum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getGreatestMinimum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getLeastMaximum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getActualMinimum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int getActualMaximum(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object clone(@GuardSatisfied Calendar this);

    @FromByteCode
    @FromByteCode
    static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String getFieldName(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var0);

    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String toString(@GuardSatisfied Calendar this);

    private static void appendValue(StringBuilder var0, String var1, boolean var2, long var3);

    private void setWeekCountData(Locale var1);

    private void updateTime();

    @Override
    private int compareTo(long var1);

    private static long getMillisOf(Calendar var0);

    private void adjustStamp();

    private void invalidateWeekFields();

    private synchronized void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public final Instant toInstant();

    static;

    public static class Builder {
        private static final int NFIELDS = 18;
        private static final int WEEK_YEAR = 17;
        private long instant;
        private int[] fields;
        private int nextStamp;
        private int maxFieldIndex;
        private String type;
        private TimeZone zone;
        private boolean lenient = true;
        private Locale locale;
        private int firstDayOfWeek;
        private int minimalDaysInFirstWeek;

        public Builder setInstant(long instant) {
            if (this.fields != null) {
                throw new IllegalStateException();
            }
            this.instant = instant;
            this.nextStamp = 1;
            return this;
        }

        public Builder setInstant(Date instant) {
            return this.setInstant(instant.getTime());
        }

        public Builder set(int field, int value) {
            if (field < 0 || field >= 17) {
                throw new IllegalArgumentException("field is invalid");
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            this.allocateFields();
            this.internalSet(field, value);
            return this;
        }

        public Builder setFields(int ... fieldValuePairs) {
            int len = fieldValuePairs.length;
            if (len % 2 != 0) {
                throw new IllegalArgumentException();
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            if (this.nextStamp + len / 2 < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.allocateFields();
            int i = 0;
            while (i < len) {
                int field;
                if ((field = fieldValuePairs[i++]) < 0 || field >= 17) {
                    throw new IllegalArgumentException("field is invalid");
                }
                this.internalSet(field, fieldValuePairs[i++]);
            }
            return this;
        }

        public Builder setDate(int year, int month, int dayOfMonth) {
            return this.setFields(1, year, 2, month, 5, dayOfMonth);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second) {
            return this.setTimeOfDay(hourOfDay, minute, second, 0);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second, int millis) {
            return this.setFields(11, hourOfDay, 12, minute, 13, second, 14, millis);
        }

        public Builder setWeekDate(int weekYear, int weekOfYear, int dayOfWeek) {
            this.allocateFields();
            this.internalSet(17, weekYear);
            this.internalSet(3, weekOfYear);
            this.internalSet(7, dayOfWeek);
            return this;
        }

        public Builder setTimeZone(TimeZone zone) {
            if (zone == null) {
                throw new NullPointerException();
            }
            this.zone = zone;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setCalendarType(String type) {
            if (type.equals("gregorian")) {
                type = "gregory";
            }
            if (!Calendar.getAvailableCalendarTypes().contains(type) && !type.equals("iso8601")) {
                throw new IllegalArgumentException("unknown calendar type: " + type);
            }
            if (this.type == null) {
                this.type = type;
            } else if (!this.type.equals(type)) {
                throw new IllegalStateException("calendar type override");
            }
            return this;
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException();
            }
            this.locale = locale;
            return this;
        }

        public Builder setWeekDefinition(int firstDayOfWeek, int minimalDaysInFirstWeek) {
            if (!this.isValidWeekParameter(firstDayOfWeek) || !this.isValidWeekParameter(minimalDaysInFirstWeek)) {
                throw new IllegalArgumentException();
            }
            this.firstDayOfWeek = firstDayOfWeek;
            this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
            return this;
        }

        public Calendar build() {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this.zone == null) {
                this.zone = Calendar.defaultTimeZone((Locale)this.locale);
            }
            if (this.type == null) {
                this.type = this.locale.getUnicodeLocaleType("ca");
            }
            if (this.type == null) {
                this.type = this.locale.getCountry() == "TH" && this.locale.getLanguage() == "th" ? "buddhist" : "gregory";
            }
            Calendar cal = switch (this.type) {
                case "gregory" -> new GregorianCalendar(this.zone, this.locale, true);
                case "iso8601" -> {
                    GregorianCalendar gcal = new GregorianCalendar(this.zone, this.locale, true);
                    gcal.setGregorianChange(new Date(Long.MIN_VALUE));
                    this.setWeekDefinition(2, 4);
                    yield gcal;
                }
                case "buddhist" -> {
                    BuddhistCalendar buddhistCalendar = new BuddhistCalendar(this.zone, this.locale);
                    buddhistCalendar.clear();
                    yield buddhistCalendar;
                }
                case "japanese" -> new JapaneseImperialCalendar(this.zone, this.locale, true);
                default -> throw new IllegalArgumentException("unknown calendar type: " + this.type);
            };
            cal.setLenient(this.lenient);
            if (this.firstDayOfWeek != 0) {
                cal.setFirstDayOfWeek(this.firstDayOfWeek);
                cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            if (this.isInstantSet()) {
                cal.setTimeInMillis(this.instant);
                cal.complete();
                return cal;
            }
            if (this.fields != null) {
                boolean weekDate;
                boolean bl = weekDate = this.isSet(17) && this.fields[17] > this.fields[1];
                if (weekDate && !cal.isWeekDateSupported()) {
                    throw new IllegalArgumentException("week date is unsupported by " + this.type);
                }
                block12: for (int stamp = 2; stamp < this.nextStamp; ++stamp) {
                    for (int index = 0; index <= this.maxFieldIndex; ++index) {
                        if (this.fields[index] != stamp) continue;
                        cal.set(index, this.fields[18 + index]);
                        continue block12;
                    }
                }
                if (weekDate) {
                    int weekOfYear = this.isSet(3) ? this.fields[21] : 1;
                    int dayOfWeek = this.isSet(7) ? this.fields[25] : cal.getFirstDayOfWeek();
                    cal.setWeekDate(this.fields[35], weekOfYear, dayOfWeek);
                }
                cal.complete();
            }
            return cal;
        }

        private void allocateFields() {
            if (this.fields == null) {
                this.fields = new int[36];
                this.nextStamp = 2;
                this.maxFieldIndex = -1;
            }
        }

        private void internalSet(int field, int value) {
            ++this.nextStamp;
            if (this.nextStamp < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.fields[18 + field] = value;
            if (field > this.maxFieldIndex && field < 17) {
                this.maxFieldIndex = field;
            }
        }

        private boolean isInstantSet() {
            return this.nextStamp == 1;
        }

        private boolean isSet(int index) {
            return this.fields != null && this.fields[index] > 0;
        }

        private boolean isValidWeekParameter(int value) {
            return value > 0 && value <= 7;
        }
    }

    private static class AvailableCalendarTypes {
        private static final Set<String> SET = Set.of((Object)"gregory", (Object)"buddhist", (Object)"japanese");

        private AvailableCalendarTypes() {
        }
    }

    private static class CalendarAccessControlContext {
        private static final AccessControlContext INSTANCE;

        private CalendarAccessControlContext() {
        }

        static {
            RuntimePermission perm = new RuntimePermission("accessClassInPackage.sun.util.calendar");
            PermissionCollection perms = perm.newPermissionCollection();
            perms.add(perm);
            INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    }
}

