/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.SerialCallbackContext;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import jdk.Profile+Annotation;
import jdk.internal.util.ByteArray;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.framework.qual.FromByteCode;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker;
    private static final HashMap<String, Class<?>> primClasses;
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle;
    private boolean defaultDataEnd;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;

    @FromByteCode
    public ObjectInputStream(@UnknownKeyFor @NonNull @Initialized InputStream var1) throws IOException;

    protected ObjectInputStream() throws IOException, SecurityException;

    @Override
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized Object readObject() throws IOException, ClassNotFoundException;

    protected Object readObjectOverride() throws IOException, ClassNotFoundException;

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized Object readUnshared() throws IOException, ClassNotFoundException;

    @FromByteCode
    public void defaultReadObject() throws IOException, ClassNotFoundException;

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized GetField readFields() throws IOException, ClassNotFoundException;

    @FromByteCode
    public void registerValidation(@UnknownKeyFor @NonNull @Initialized ObjectInputValidation var1, @UnknownKeyFor @NonNull @Initialized int var2) throws NotActiveException, InvalidObjectException;

    protected Class<?> resolveClass(ObjectStreamClass var1) throws IOException, ClassNotFoundException;

    protected Class<?> resolveProxyClass(String[] var1) throws IOException, ClassNotFoundException;

    protected Object resolveObject(Object var1) throws IOException;

    protected boolean enableResolveObject(boolean var1) throws SecurityException;

    protected void readStreamHeader() throws IOException, StreamCorruptedException;

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int read() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3) throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int available() throws IOException;

    @Override
    @FromByteCode
    public void close() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean readBoolean() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized byte readByte() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int readUnsignedByte() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized char readChar() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized short readShort() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int readUnsignedShort() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int readInt() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized long readLong() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized float readFloat() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized double readDouble() throws IOException;

    @Override
    @FromByteCode
    public void readFully(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1) throws IOException;

    @Override
    @FromByteCode
    public void readFully(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3) throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int skipBytes(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @Deprecated
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized String readLine() throws IOException;

    @Override
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized String readUTF() throws IOException;

    private void verifySubclass();

    private static boolean auditSubclass(Class<?> var0);

    private void clear();

    private Object readObject0(boolean var1) throws IOException;

    private Object checkResolve(Object var1) throws IOException;

    String readTypeString() throws IOException;

    private Object readNull() throws IOException;

    private Object readHandle(boolean var1) throws IOException;

    private Class<?> readClass(boolean var1) throws IOException;

    private ObjectStreamClass readClassDesc(boolean var1) throws IOException;

    private boolean isCustomSubclass();

    private ObjectStreamClass readProxyDesc(boolean var1) throws IOException;

    private ObjectStreamClass readNonProxyDesc(boolean var1) throws IOException;

    private String readString(boolean var1) throws IOException;

    private Object readArray(boolean var1) throws IOException;

    private Enum<?> readEnum(boolean var1) throws IOException;

    private Object readOrdinaryObject(boolean var1) throws IOException;

    private void readExternalData(Externalizable var1, ObjectStreamClass var2) throws IOException;

    private void readSerialData(Object var1, ObjectStreamClass var2) throws IOException;

    private void skipCustomData() throws IOException;

    private void defaultReadFields(Object var1, ObjectStreamClass var2) throws IOException;

    private IOException readFatalException() throws IOException;

    private void handleReset() throws StreamCorruptedException;

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static ClassLoader latestUserDefinedLoader();

    private static Object cloneArray(Object var0);

    static;

    private static class Caches {
        static final ClassValue<Boolean> subclassAudits = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                return ObjectInputStream.auditSubclass(type);
            }
        };
        static final boolean SET_FILTER_AFTER_READ = GetBooleanAction.privilegedGetProperty("jdk.serialSetFilterAfterRead");
        private static final boolean GETFIELD_CNFE_RETURNS_NULL = GetBooleanAction.privilegedGetProperty("jdk.serialGetFieldCnfeReturnsNull");
        static final int PROXY_INTERFACE_LIMIT = Math.clamp((long)GetIntegerAction.privilegedGetProperty("jdk.serialProxyInterfaceLimit", 65535).intValue(), (int)0, (int)65535);

        private Caches() {
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     * Exception performing whole class analysis ignored.
     */
    public static abstract class GetField {
        @FromByteCode
        public GetField();

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized ObjectStreamClass getObjectStreamClass();

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized boolean defaulted(@UnknownKeyFor @NonNull @Initialized String var1) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized boolean get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized boolean var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized byte get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized byte var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized char get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized char var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized short get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized short var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized int get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized int var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized long get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized long var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized float get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized float var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized double get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized double var2) throws IOException;

        @FromByteCode
        public abstract @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2) throws IOException;
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation obj, int priority) throws InvalidObjectException {
            if (obj == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback prev = null;
            Callback cur = this.list;
            while (cur != null && priority < cur.priority) {
                prev = cur;
                cur = cur.next;
            }
            AccessControlContext acc = AccessController.getContext();
            if (prev != null) {
                prev.next = new Callback(obj, priority, cur, acc);
            } else {
                this.list = new Callback(obj, priority, this.list, acc);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InvalidObjectException {
                            list.obj.validateObject();
                            return null;
                        }
                    }, this.list.acc);
                    this.list = this.list.next;
                }
            }
            catch (PrivilegedActionException ex) {
                this.list = null;
                throw (InvalidObjectException)ex.getException();
            }
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation obj, int priority, Callback next, AccessControlContext acc) {
                this.obj = obj;
                this.priority = priority;
                this.next = next;
                this.acc = acc;
            }
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;
        private long totalBytesRead = 0L;

        PeekInputStream(InputStream in) {
            this.in = in;
        }

        int peek() throws IOException {
            if (this.peekb >= 0) {
                return this.peekb;
            }
            this.peekb = this.in.read();
            this.totalBytesRead += this.peekb >= 0 ? 1L : 0L;
            return this.peekb;
        }

        @Override
        public int read() throws IOException {
            if (this.peekb >= 0) {
                int v = this.peekb;
                this.peekb = -1;
                return v;
            }
            int nbytes = this.in.read();
            this.totalBytesRead += nbytes >= 0 ? 1L : 0L;
            return nbytes;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nbytes;
            if (len == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                int nbytes2 = this.in.read(b, off, len);
                this.totalBytesRead += nbytes2 >= 0 ? (long)nbytes2 : 0L;
                return nbytes2;
            }
            b[off++] = (byte)this.peekb;
            this.peekb = -1;
            this.totalBytesRead += (nbytes = this.in.read(b, off, --len)) >= 0 ? (long)nbytes : 0L;
            return nbytes >= 0 ? nbytes + 1 : 1;
        }

        void readFully(byte[] b, int off, int len) throws IOException {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skipped = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++skipped;
                --n;
            }
            n = (long)skipped + this.in.skip(n);
            this.totalBytesRead += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public long getBytesRead() {
            return this.totalBytesRead;
        }
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream in) {
            this.in = new PeekInputStream(in);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean newmode) throws IOException {
            if (this.blkmode == newmode) {
                return this.blkmode;
            }
            if (newmode) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw new IllegalStateException("unread block data");
            }
            this.blkmode = newmode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        void skipBlockData() throws IOException {
            if (!this.blkmode) {
                throw new IllegalStateException("not in block data mode");
            }
            while (this.end >= 0) {
                this.refill();
            }
        }

        private int readBlockHeader(boolean canBlock) throws IOException {
            if (ObjectInputStream.this.defaultDataEnd) {
                return -1;
            }
            try {
                int tc;
                block7: while (true) {
                    int avail;
                    int n = avail = canBlock ? Integer.MAX_VALUE : this.in.available();
                    if (avail == 0) {
                        return -2;
                    }
                    tc = this.in.peek();
                    switch (tc) {
                        case 119: {
                            if (avail < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            if (avail < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int len = ByteArray.getInt(this.hbuf, 1);
                            if (len < 0) {
                                throw new StreamCorruptedException("illegal block data header length: " + len);
                            }
                            return len;
                        }
                        case 121: {
                            this.in.read();
                            ObjectInputStream.this.handleReset();
                            continue block7;
                        }
                    }
                    break;
                }
                if (tc >= 0 && (tc < 112 || tc > 126)) {
                    throw new StreamCorruptedException(String.format("invalid type code: %02X", tc));
                }
                return -1;
            }
            catch (EOFException ex) {
                throw new StreamCorruptedException("unexpected EOF while reading block data header");
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n = this.in.read(this.buf, 0, Math.min(this.unread, 1024));
                        if (n >= 0) {
                            this.end = n;
                            this.unread -= n;
                            continue;
                        }
                        throw new StreamCorruptedException("unexpected EOF in middle of data block");
                    }
                    n = this.readBlockHeader(true);
                    if (n >= 0) {
                        this.end = 0;
                        this.unread = n;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException ex) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw ex;
            }
        }

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        byte peekByte() throws IOException {
            int val = this.peek();
            if (val < 0) {
                throw new EOFException();
            }
            return (byte)val;
        }

        @Override
        public int read() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.read(b, off, len, false);
        }

        @Override
        public long skip(long len) throws IOException {
            long remain = len;
            while (remain > 0L) {
                int nread;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    nread = (int)Math.min(remain, (long)(this.end - this.pos));
                    remain -= (long)nread;
                    this.pos += nread;
                    continue;
                }
                nread = (int)Math.min(remain, 1024L);
                if ((nread = this.in.read(this.buf, 0, nread)) < 0) break;
                remain -= (long)nread;
            }
            return len - remain;
        }

        @Override
        public int available() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end && this.unread == 0) {
                    int n;
                    while ((n = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n;
                        }
                    }
                }
                int unreadAvail = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + unreadAvail : 0;
            }
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        int read(byte[] b, int off, int len, boolean copy) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int nread = Math.min(len, this.end - this.pos);
                System.arraycopy(this.buf, this.pos, b, off, nread);
                this.pos += nread;
                return nread;
            }
            if (copy) {
                int nread = this.in.read(this.buf, 0, Math.min(len, 1024));
                if (nread > 0) {
                    System.arraycopy(this.buf, 0, b, off, nread);
                }
                return nread;
            }
            return this.in.read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length, false);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.readFully(b, off, len, false);
        }

        public void readFully(byte[] b, int off, int len, boolean copy) throws IOException {
            while (len > 0) {
                int n = this.read(b, off, len, copy);
                if (n < 0) {
                    throw new EOFException();
                }
                off += n;
                len -= n;
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.din.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v != 0;
        }

        @Override
        public byte readByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return (byte)v;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v;
        }

        @Override
        public char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char v = ByteArray.getChar(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        @Override
        public short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short v = ByteArray.getShort(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int v = ByteArray.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return v;
        }

        @Override
        public int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int v = ByteArray.getInt(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        @Override
        public float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float v = ByteArray.getFloat(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        @Override
        public long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long v = ByteArray.getLong(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        @Override
        public double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double v = ByteArray.getDouble(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        void readBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 1024);
                    this.in.readFully(this.buf, 0, span);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        v[off++] = this.din.readBoolean();
                        continue;
                    }
                    stop = Math.min(endoff, off + this.end - this.pos);
                }
                while (off < stop) {
                    v[off++] = ByteArray.getBoolean(this.buf, this.pos++);
                }
            }
        }

        void readChars(char[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 512);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readChar();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = ByteArray.getChar(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readShorts(short[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 512);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readShort();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = ByteArray.getShort(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        void readInts(int[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 256);
                    this.in.readFully(this.buf, 0, span << 2);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readInt();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 2));
                }
                while (off < stop) {
                    v[off++] = ByteArray.getInt(this.buf, this.pos);
                    this.pos += 4;
                }
            }
        }

        void readFloats(float[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 256);
                    this.in.readFully(this.buf, 0, span << 2);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readFloat();
                        continue;
                    }
                    stop = Math.min(endoff, this.end - this.pos >> 2);
                }
                while (off < stop) {
                    v[off++] = ByteArray.getFloat(this.buf, this.pos);
                    this.pos += 4;
                }
            }
        }

        void readLongs(long[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 128);
                    this.in.readFully(this.buf, 0, span << 3);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readLong();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 3));
                }
                while (off < stop) {
                    v[off++] = ByteArray.getLong(this.buf, this.pos);
                    this.pos += 8;
                }
            }
        }

        void readDoubles(double[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, 128);
                    this.in.readFully(this.buf, 0, span << 3);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readDouble();
                        continue;
                    }
                    stop = Math.min(endoff - off, this.end - this.pos >> 3);
                }
                while (off < stop) {
                    v[off++] = ByteArray.getDouble(this.buf, this.pos);
                    this.pos += 8;
                }
            }
        }

        String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        private String readUTFBody(long utflen) throws IOException {
            StringBuilder sbuf;
            if (utflen > 0L && utflen < Integer.MAX_VALUE) {
                int initialCapacity = Math.min((int)utflen, 65535);
                sbuf = new StringBuilder(initialCapacity);
            } else {
                sbuf = new StringBuilder();
            }
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (utflen > 0L) {
                int avail = this.end - this.pos;
                if (avail >= 3 || (long)avail == utflen) {
                    utflen -= this.readUTFSpan(sbuf, utflen);
                    continue;
                }
                if (this.blkmode) {
                    utflen -= (long)this.readUTFChar(sbuf, utflen);
                    continue;
                }
                if (avail > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, avail);
                }
                this.pos = 0;
                this.end = (int)Math.min(1024L, utflen);
                this.in.readFully(this.buf, avail, this.end - avail);
            }
            return sbuf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readUTFSpan(StringBuilder sbuf, long utflen) throws IOException {
            int start;
            int cpos;
            block13: {
                cpos = 0;
                start = this.pos;
                int avail = Math.min(this.end - this.pos, 256);
                int stop = this.pos + (utflen > (long)avail ? avail - 2 : (int)utflen);
                boolean outOfBounds = false;
                try {
                    block10: while (this.pos < stop) {
                        int b1 = this.buf[this.pos++] & 0xFF;
                        switch (b1 >> 4) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.cbuf[cpos++] = (char)b1;
                                continue block10;
                            }
                            case 12: 
                            case 13: {
                                byte b2 = this.buf[this.pos++];
                                if ((b2 & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[cpos++] = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                                continue block10;
                            }
                            case 14: {
                                byte b3 = this.buf[this.pos + 1];
                                byte b2 = this.buf[this.pos + 0];
                                this.pos += 2;
                                if ((b2 & 0xC0) != 128) throw new UTFDataFormatException();
                                if ((b3 & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[cpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                                continue block10;
                            }
                        }
                        throw new UTFDataFormatException();
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    outOfBounds = true;
                    return (long)outOfBounds;
                }
                finally {
                    if (!outOfBounds && (long)(this.pos - start) <= utflen) break block13;
                    this.pos = start + (int)utflen;
                    throw new UTFDataFormatException();
                }
            }
            sbuf.append(this.cbuf, 0, cpos);
            return this.pos - start;
        }

        private int readUTFChar(StringBuilder sbuf, long utflen) throws IOException {
            int b1 = this.readByte() & 0xFF;
            switch (b1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sbuf.append((char)b1);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (utflen < 2L) {
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    if ((b2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (utflen < 3L) {
                        if (utflen == 2L) {
                            this.readByte();
                        }
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    byte b3 = this.readByte();
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                    return 3;
                }
            }
            throw new UTFDataFormatException();
        }

        long getBytesRead() {
            return this.in.getBytesRead();
        }
    }

    private static final class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int initialCapacity) {
            this.status = new byte[initialCapacity];
            this.entries = new Object[initialCapacity];
            this.deps = new HandleList[initialCapacity];
        }

        int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = obj;
            return this.size++;
        }

        void markDependency(int dependent, int target) {
            if (dependent == target || dependent == -1 || target == -1) {
                return;
            }
            block0 : switch (this.status[dependent]) {
                case 2: {
                    switch (this.status[target]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(dependent, (ClassNotFoundException)this.entries[target]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[target] == null) {
                                this.deps[target] = new HandleList();
                            }
                            this.deps[target].add(dependent);
                            if (this.lowDep >= 0 && this.lowDep <= target) break block0;
                            this.lowDep = target;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void markException(int handle, ClassNotFoundException ex) {
            switch (this.status[handle]) {
                case 2: {
                    this.status[handle] = 3;
                    this.entries[handle] = ex;
                    HandleList dlist = this.deps[handle];
                    if (dlist == null) break;
                    int ndeps = dlist.size();
                    for (int i = 0; i < ndeps; ++i) {
                        this.markException(dlist.get(i), ex);
                    }
                    this.deps[handle] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void finish(int handle) {
            int end;
            if (this.lowDep < 0) {
                end = handle + 1;
            } else if (this.lowDep >= handle) {
                end = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = handle; i < end; ++i) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObject(int handle, Object obj) {
            switch (this.status[handle]) {
                case 1: 
                case 2: {
                    this.entries[handle] = obj;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int handle) {
            return handle != -1 && this.status[handle] != 3 ? this.entries[handle] : null;
        }

        ClassNotFoundException lookupException(int handle) {
            return handle != -1 && this.status[handle] == 3 ? (ClassNotFoundException)this.entries[handle] : null;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int newCapacity = (this.entries.length << 1) + 1;
            byte[] newStatus = new byte[newCapacity];
            Object[] newEntries = new Object[newCapacity];
            HandleList[] newDeps = new HandleList[newCapacity];
            System.arraycopy(this.status, 0, newStatus, 0, this.size);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            System.arraycopy(this.deps, 0, newDeps, 0, this.size);
            this.status = newStatus;
            this.entries = newEntries;
            this.deps = newDeps;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int handle) {
                if (this.size >= this.list.length) {
                    int[] newList = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, newList, 0, this.list.length);
                    this.list = newList;
                }
                this.list[this.size++] = handle;
            }

            public int get(int index) {
                if (index >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[index];
            }

            public int size() {
                return this.size;
            }
        }
    }
}

