/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.JapaneseImperialCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.igj.qual.ReadOnly;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import sun.util.BuddhistCalendar;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
@Profile+Annotation(value=1)
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final @UnknownKeyFor @NonNull @Initialized int ERA = 0;
    public static final @UnknownKeyFor @NonNull @Initialized int YEAR = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int MONTH = 2;
    public static final @UnknownKeyFor @NonNull @Initialized int WEEK_OF_YEAR = 3;
    public static final @UnknownKeyFor @NonNull @Initialized int WEEK_OF_MONTH = 4;
    public static final @UnknownKeyFor @NonNull @Initialized int DATE = 5;
    public static final @UnknownKeyFor @NonNull @Initialized int DAY_OF_MONTH = 5;
    public static final @UnknownKeyFor @NonNull @Initialized int DAY_OF_YEAR = 6;
    public static final @UnknownKeyFor @NonNull @Initialized int DAY_OF_WEEK = 7;
    public static final @UnknownKeyFor @NonNull @Initialized int DAY_OF_WEEK_IN_MONTH = 8;
    public static final @UnknownKeyFor @NonNull @Initialized int AM_PM = 9;
    public static final @UnknownKeyFor @NonNull @Initialized int HOUR = 10;
    public static final @UnknownKeyFor @NonNull @Initialized int HOUR_OF_DAY = 11;
    public static final @UnknownKeyFor @NonNull @Initialized int MINUTE = 12;
    public static final @UnknownKeyFor @NonNull @Initialized int SECOND = 13;
    public static final @UnknownKeyFor @NonNull @Initialized int MILLISECOND = 14;
    public static final @UnknownKeyFor @NonNull @Initialized int ZONE_OFFSET = 15;
    public static final @UnknownKeyFor @NonNull @Initialized int DST_OFFSET = 16;
    public static final @UnknownKeyFor @NonNull @Initialized int FIELD_COUNT = 17;
    public static final @UnknownKeyFor @NonNull @Initialized int SUNDAY = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int MONDAY = 2;
    public static final @UnknownKeyFor @NonNull @Initialized int TUESDAY = 3;
    public static final @UnknownKeyFor @NonNull @Initialized int WEDNESDAY = 4;
    public static final @UnknownKeyFor @NonNull @Initialized int THURSDAY = 5;
    public static final @UnknownKeyFor @NonNull @Initialized int FRIDAY = 6;
    public static final @UnknownKeyFor @NonNull @Initialized int SATURDAY = 7;
    public static final @UnknownKeyFor @NonNull @Initialized int JANUARY = 0;
    public static final @UnknownKeyFor @NonNull @Initialized int FEBRUARY = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int MARCH = 2;
    public static final @UnknownKeyFor @NonNull @Initialized int APRIL = 3;
    public static final @UnknownKeyFor @NonNull @Initialized int MAY = 4;
    public static final @UnknownKeyFor @NonNull @Initialized int JUNE = 5;
    public static final @UnknownKeyFor @NonNull @Initialized int JULY = 6;
    public static final @UnknownKeyFor @NonNull @Initialized int AUGUST = 7;
    public static final @UnknownKeyFor @NonNull @Initialized int SEPTEMBER = 8;
    public static final @UnknownKeyFor @NonNull @Initialized int OCTOBER = 9;
    public static final @UnknownKeyFor @NonNull @Initialized int NOVEMBER = 10;
    public static final @UnknownKeyFor @NonNull @Initialized int DECEMBER = 11;
    public static final @UnknownKeyFor @NonNull @Initialized int UNDECIMBER = 12;
    public static final @UnknownKeyFor @NonNull @Initialized int AM = 0;
    public static final @UnknownKeyFor @NonNull @Initialized int PM = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int ALL_STYLES = 0;
    static final int STANDALONE_MASK = 32768;
    public static final @UnknownKeyFor @NonNull @Initialized int SHORT = 1;
    public static final @UnknownKeyFor @NonNull @Initialized int LONG = 2;
    public static final int NARROW_FORMAT = 4;
    public static final int NARROW_STANDALONE = 32772;
    public static final int SHORT_FORMAT = 1;
    public static final int LONG_FORMAT = 2;
    public static final int SHORT_STANDALONE = 32769;
    public static final int LONG_STANDALONE = 32770;
    protected int[] fields;
    protected boolean[] isSet;
    private transient int[] stamp;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient;
    private TimeZone zone;
    private transient boolean sharedZone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static final ConcurrentMap<Locale, int[]> cachedLocaleData;
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    static final int ALL_FIELDS = 131071;
    private int nextStamp;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream;
    static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -1807547505821590642L;
    static final int ERA_MASK = 1;
    static final int YEAR_MASK = 2;
    static final int MONTH_MASK = 4;
    static final int WEEK_OF_YEAR_MASK = 8;
    static final int WEEK_OF_MONTH_MASK = 16;
    static final int DAY_OF_MONTH_MASK = 32;
    static final int DATE_MASK = 32;
    static final int DAY_OF_YEAR_MASK = 64;
    static final int DAY_OF_WEEK_MASK = 128;
    static final int DAY_OF_WEEK_IN_MONTH_MASK = 256;
    static final int AM_PM_MASK = 512;
    static final int HOUR_MASK = 1024;
    static final int HOUR_OF_DAY_MASK = 2048;
    static final int MINUTE_MASK = 4096;
    static final int SECOND_MASK = 8192;
    static final int MILLISECOND_MASK = 16384;
    static final int ZONE_OFFSET_MASK = 32768;
    static final int DST_OFFSET_MASK = 65536;
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] FIELD_NAME;

    @FromByteCode
    protected Calendar();

    protected Calendar(TimeZone var1, Locale var2);

    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @I Calendar getInstance();

    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @I Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @ReadOnly TimeZone var0);

    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @I Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @ReadOnly Locale var0);

    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @I Calendar getInstance(@UnknownKeyFor @NonNull @Initialized @ReadOnly TimeZone var0, @UnknownKeyFor @NonNull @Initialized Locale var1);

    private static Calendar createCalendar(TimeZone var0, Locale var1);

    @FromByteCode
    public static synchronized @UnknownKeyFor @NonNull @Initialized Locale @UnknownKeyFor @NonNull @Initialized @ReadOnly [] getAvailableLocales();

    protected abstract void computeTime();

    protected abstract void computeFields();

    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @I Date getTime(@ReadOnly Calendar this);

    @FromByteCode
    public final void setTime(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized Date var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized long getTimeInMillis(@ReadOnly Calendar this);

    @FromByteCode
    public void setTimeInMillis(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized long var1);

    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int get(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized int var1);

    protected final int internalGet(int var1);

    final void internalSet(int var1, int var2);

    @FromByteCode
    public void set(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2);

    @FromByteCode
    public final void set(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3);

    @FromByteCode
    public final void set(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3, @UnknownKeyFor @NonNull @Initialized int var4, @UnknownKeyFor @NonNull @Initialized int var5);

    @FromByteCode
    public final void set(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3, @UnknownKeyFor @NonNull @Initialized int var4, @UnknownKeyFor @NonNull @Initialized int var5, @UnknownKeyFor @NonNull @Initialized int var6);

    @FromByteCode
    public final void clear(@AssignsFields Calendar this);

    @FromByteCode
    public final void clear(@AssignsFields Calendar this, @UnknownKeyFor @NonNull @Initialized int var1);

    @Pure
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized boolean isSet(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized String getDisplayName(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized Locale var3);

    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> getDisplayNames(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized Locale var3);

    private Map<String, Integer> getDisplayNamesImpl(int var1, int var2, Locale var3);

    boolean checkDisplayNameParams(int var1, int var2, int var3, int var4, Locale var5, int var6);

    private String[] getFieldStrings(int var1, int var2, DateFormatSymbols var3);

    protected void complete();

    final boolean isExternallySet(int var1);

    final int getSetStateFields();

    final void setFieldsComputed(int var1);

    final void setFieldsNormalized(int var1);

    final boolean isPartiallyNormalized();

    final boolean isFullyNormalized();

    final void setUnnormalized();

    static boolean isFieldSet(int var0, int var1);

    final int selectFields();

    int getBaseStyle(int var1);

    boolean isStandaloneStyle(int var1);

    boolean isNarrowStyle(int var1);

    private static int aggregateStamp(int var0, int var1);

    public static Set<String> getAvailableCalendarTypes();

    public String getCalendarType();

    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@ReadOnly Calendar this, @Nullable @UnknownKeyFor @Initialized @ReadOnly Object var1);

    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int hashCode(@ReadOnly Calendar this);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean before(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized Object var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean after(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized Object var1);

    @Override
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int compareTo(@ReadOnly Calendar this, @UnknownKeyFor @NonNull @Initialized @ReadOnly Calendar var1);

    @FromByteCode
    public abstract void add(@Mutable Calendar this, @UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2);

    @FromByteCode
    public abstract void roll(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized boolean var2);

    @FromByteCode
    public void roll(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2);

    @FromByteCode
    public void setTimeZone(@UnknownKeyFor @NonNull @Initialized TimeZone var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized TimeZone getTimeZone();

    TimeZone getZone();

    void setZoneShared(boolean var1);

    @FromByteCode
    public void setLenient(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized boolean isLenient();

    @FromByteCode
    public void setFirstDayOfWeek(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int getFirstDayOfWeek();

    @FromByteCode
    public void setMinimalDaysInFirstWeek(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int getMinimalDaysInFirstWeek();

    public boolean isWeekDateSupported();

    public int getWeekYear();

    public void setWeekDate(int var1, int var2, int var3);

    public int getWeeksInWeekYear();

    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized int getMinimum(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized int getMaximum(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized int getGreatestMinimum(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized int getLeastMaximum(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int getActualMinimum(@UnknownKeyFor @NonNull @Initialized int var1);

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized int getActualMaximum(@UnknownKeyFor @NonNull @Initialized int var1);

    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I(value="N") Object clone();

    @FromByteCode
    static @UnknownKeyFor @NonNull @Initialized String getFieldName(@UnknownKeyFor @NonNull @Initialized int var0);

    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized String toString();

    private static void appendValue(StringBuilder var0, String var1, boolean var2, long var3);

    private void setWeekCountData(Locale var1);

    private void updateTime();

    @Override
    private int compareTo(long var1);

    private static long getMillisOf(Calendar var0);

    private void adjustStamp();

    private void invalidateWeekFields();

    private synchronized void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public final Instant toInstant();

    static;

    public static class Builder {
        private static final int NFIELDS = 18;
        private static final int WEEK_YEAR = 17;
        private long instant;
        private int[] fields;
        private int nextStamp;
        private int maxFieldIndex;
        private String type;
        private TimeZone zone;
        private boolean lenient = true;
        private Locale locale;
        private int firstDayOfWeek;
        private int minimalDaysInFirstWeek;

        public Builder setInstant(long instant) {
            if (this.fields != null) {
                throw new IllegalStateException();
            }
            this.instant = instant;
            this.nextStamp = 1;
            return this;
        }

        public Builder setInstant(Date instant) {
            return this.setInstant(instant.getTime());
        }

        public Builder set(int field, int value) {
            if (field < 0 || field >= 17) {
                throw new IllegalArgumentException("field is invalid");
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            this.allocateFields();
            this.internalSet(field, value);
            return this;
        }

        public Builder setFields(int ... fieldValuePairs) {
            int len = fieldValuePairs.length;
            if (len % 2 != 0) {
                throw new IllegalArgumentException();
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            if (this.nextStamp + len / 2 < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.allocateFields();
            int i = 0;
            while (i < len) {
                int field;
                if ((field = fieldValuePairs[i++]) < 0 || field >= 17) {
                    throw new IllegalArgumentException("field is invalid");
                }
                this.internalSet(field, fieldValuePairs[i++]);
            }
            return this;
        }

        public Builder setDate(int year, int month, int dayOfMonth) {
            return this.setFields(1, year, 2, month, 5, dayOfMonth);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second) {
            return this.setTimeOfDay(hourOfDay, minute, second, 0);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second, int millis) {
            return this.setFields(11, hourOfDay, 12, minute, 13, second, 14, millis);
        }

        public Builder setWeekDate(int weekYear, int weekOfYear, int dayOfWeek) {
            this.allocateFields();
            this.internalSet(17, weekYear);
            this.internalSet(3, weekOfYear);
            this.internalSet(7, dayOfWeek);
            return this;
        }

        public Builder setTimeZone(TimeZone zone) {
            if (zone == null) {
                throw new NullPointerException();
            }
            this.zone = zone;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setCalendarType(String type) {
            if (type.equals("gregorian")) {
                type = "gregory";
            }
            if (!Calendar.getAvailableCalendarTypes().contains(type) && !type.equals("iso8601")) {
                throw new IllegalArgumentException("unknown calendar type: " + type);
            }
            if (this.type == null) {
                this.type = type;
            } else if (!this.type.equals(type)) {
                throw new IllegalStateException("calendar type override");
            }
            return this;
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException();
            }
            this.locale = locale;
            return this;
        }

        public Builder setWeekDefinition(int firstDayOfWeek, int minimalDaysInFirstWeek) {
            if (!this.isValidWeekParameter(firstDayOfWeek) || !this.isValidWeekParameter(minimalDaysInFirstWeek)) {
                throw new IllegalArgumentException();
            }
            this.firstDayOfWeek = firstDayOfWeek;
            this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
            return this;
        }

        public Calendar build() {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this.zone == null) {
                this.zone = Calendar.defaultTimeZone((Locale)this.locale);
            }
            if (this.type == null) {
                this.type = this.locale.getUnicodeLocaleType("ca");
            }
            if (this.type == null) {
                this.type = this.locale.getCountry() == "TH" && this.locale.getLanguage() == "th" ? "buddhist" : "gregory";
            }
            Calendar cal = switch (this.type) {
                case "gregory" -> new GregorianCalendar(this.zone, this.locale, true);
                case "iso8601" -> {
                    GregorianCalendar gcal = new GregorianCalendar(this.zone, this.locale, true);
                    gcal.setGregorianChange(new Date(Long.MIN_VALUE));
                    this.setWeekDefinition(2, 4);
                    yield gcal;
                }
                case "buddhist" -> {
                    BuddhistCalendar buddhistCalendar = new BuddhistCalendar(this.zone, this.locale);
                    buddhistCalendar.clear();
                    yield buddhistCalendar;
                }
                case "japanese" -> new JapaneseImperialCalendar(this.zone, this.locale, true);
                default -> throw new IllegalArgumentException("unknown calendar type: " + this.type);
            };
            cal.setLenient(this.lenient);
            if (this.firstDayOfWeek != 0) {
                cal.setFirstDayOfWeek(this.firstDayOfWeek);
                cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            if (this.isInstantSet()) {
                cal.setTimeInMillis(this.instant);
                cal.complete();
                return cal;
            }
            if (this.fields != null) {
                boolean weekDate;
                boolean bl = weekDate = this.isSet(17) && this.fields[17] > this.fields[1];
                if (weekDate && !cal.isWeekDateSupported()) {
                    throw new IllegalArgumentException("week date is unsupported by " + this.type);
                }
                block12: for (int stamp = 2; stamp < this.nextStamp; ++stamp) {
                    for (int index = 0; index <= this.maxFieldIndex; ++index) {
                        if (this.fields[index] != stamp) continue;
                        cal.set(index, this.fields[18 + index]);
                        continue block12;
                    }
                }
                if (weekDate) {
                    int weekOfYear = this.isSet(3) ? this.fields[21] : 1;
                    int dayOfWeek = this.isSet(7) ? this.fields[25] : cal.getFirstDayOfWeek();
                    cal.setWeekDate(this.fields[35], weekOfYear, dayOfWeek);
                }
                cal.complete();
            }
            return cal;
        }

        private void allocateFields() {
            if (this.fields == null) {
                this.fields = new int[36];
                this.nextStamp = 2;
                this.maxFieldIndex = -1;
            }
        }

        private void internalSet(int field, int value) {
            ++this.nextStamp;
            if (this.nextStamp < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.fields[18 + field] = value;
            if (field > this.maxFieldIndex && field < 17) {
                this.maxFieldIndex = field;
            }
        }

        private boolean isInstantSet() {
            return this.nextStamp == 1;
        }

        private boolean isSet(int index) {
            return this.fields != null && this.fields[index] > 0;
        }

        private boolean isValidWeekParameter(int value) {
            return value > 0 && value <= 7;
        }
    }

    private static class AvailableCalendarTypes {
        private static final Set<String> SET = Set.of((Object)"gregory", (Object)"buddhist", (Object)"japanese");

        private AvailableCalendarTypes() {
        }
    }

    private static class CalendarAccessControlContext {
        private static final AccessControlContext INSTANCE;

        private CalendarAccessControlContext() {
        }

        static {
            RuntimePermission perm = new RuntimePermission("accessClassInPackage.sun.util.calendar");
            PermissionCollection perms = perm.newPermissionCollection();
            perms.add(perm);
            INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    }
}

