/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
@Profile+Annotation(value=1)
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ELEMENTDATA;
    transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int var1);

    public ArrayList();

    public ArrayList(@org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var1);

    public void trimToSize(@AssignsFields ArrayList<E> this);

    public void ensureCapacity(@AssignsFields ArrayList<E> this, int var1);

    private void ensureCapacityInternal(int var1);

    private void ensureExplicitCapacity(int var1);

    private void grow(int var1);

    private static int hugeCapacity(int var0);

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this);

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this);

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @SideEffectFree
    public @I(value="N") Object clone(@ReadOnly ArrayList<E> this);

    @Override
    public @Nullable @ReadOnly Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this);

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, T @PolyNull [] var1);

    E elementData(int var1);

    @Override
    @Pure
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, int var1);

    @Override
    public E set(@Mutable ArrayList<E> this, int var1, E var2);

    @Override
    public boolean add(@Mutable ArrayList<E> this, E var1);

    @Override
    public void add(@Mutable ArrayList<E> this, int var1, E var2);

    @Override
    public E remove(@Mutable ArrayList<E> this, int var1);

    @Override
    public boolean remove(@Mutable ArrayList<E> this, @Nullable @ReadOnly Object var1);

    private void fastRemove(int var1);

    @Override
    public void clear(@Mutable ArrayList<E> this);

    @Override
    public boolean addAll(@Mutable ArrayList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var1);

    @Override
    public boolean addAll(@Mutable ArrayList<E> this, int var1, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var2);

    @Override
    protected void removeRange(int var1, int var2);

    private void rangeCheck(int var1);

    private void rangeCheckForAdd(int var1);

    private String outOfBoundsMsg(int var1);

    @Override
    public boolean removeAll(Collection<?> var1);

    @Override
    public boolean retainAll(Collection<?> var1);

    private boolean batchRemove(Collection<?> var1, boolean var2);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public ListIterator<E> listIterator(int var1);

    @Override
    public ListIterator<E> listIterator();

    @Override
    public Iterator<E> iterator();

    @Override
    public List<E> subList(int var1, int var2);

    static void subListRangeCheck(int var0, int var1, int var2);

    @Override
    public void forEach(Consumer<? super E> var1);

    @Override
    public Spliterator<E> spliterator();

    @Override
    public boolean removeIf(Predicate<? super E> var1);

    @Override
    public void replaceAll(UnaryOperator<E> var1);

    @Override
    public void sort(Comparator<? super E> var1);

    static;

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = ArrayList.this.size;
            if (i < size) {
                Object[] es = ArrayList.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && ArrayList.this.modCount == this.expectedModCount; ++i) {
                    action.accept(ArrayList.elementAt((Object[])es, (int)i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ArrayList<E> root;
        private final SubList<E> parent;
        private final int offset;
        private int size;

        public SubList(ArrayList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = root.modCount;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = parent.modCount;
        }

        @Override
        public E set(int index, E element) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E oldValue = this.root.elementData(this.offset + index);
            this.root.elementData[this.offset + index] = element;
            return oldValue;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            return this.root.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            this.root.replaceAllRange(operator, this.offset, this.offset + this.size);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.batchRemove(c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.batchRemove(c, true);
        }

        private boolean batchRemove(Collection<?> c, boolean complement) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.batchRemove(c, complement, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.removeIf(filter, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkForComodification();
            if (a.length < this.size) {
                return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size, a.getClass());
            }
            System.arraycopy(this.root.elementData, this.offset, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            boolean equal = this.root.equalsRange((List)o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return equal;
        }

        @Override
        public int hashCode() {
            int hash = this.root.hashCodeRange(this.offset, this.offset + this.size);
            this.checkForComodification();
            return hash;
        }

        @Override
        public int indexOf(Object o) {
            int index = this.root.indexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = this.root.lastIndexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        Object[] es = root.elementData;
                        if (offset + i >= es.length) {
                            throw new ConcurrentModificationException();
                        }
                        for (i = this.cursor; i < size && root.modCount == this.expectedModCount; ++i) {
                            action.accept(ArrayList.elementAt((Object[])es, (int)(offset + i)));
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                        this.checkForComodification();
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        root.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (root.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (this.root.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = this.root.modCount;
            } while ((slist = slist.parent) != null);
        }

        @Override
        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator arrayListSpliterator;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        arrayListSpliterator = null;
                    } else {
                        ArrayList arrayList = root;
                        Objects.requireNonNull(arrayList);
                        this.index = mid;
                        ArrayListSpliterator arrayListSpliterator2 = arrayList.new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                        arrayListSpliterator = arrayListSpliterator2;
                    }
                    return arrayListSpliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        Object e = root.elementData[i];
                        action.accept(e);
                        if (root.modCount != this.expectedModCount) {
                            throw new ConcurrentModificationException();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    ArrayList lst = root;
                    Object[] a = lst.elementData;
                    if (lst.elementData != null) {
                        int i;
                        int mc;
                        int hi = this.fence;
                        if (hi < 0) {
                            mc = modCount;
                            hi = offset + size;
                        } else {
                            mc = this.expectedModCount;
                        }
                        if (i >= 0 && (this.index = hi) <= a.length) {
                            for (i = this.index; i < hi; ++i) {
                                Object e = a[i];
                                action.accept(e);
                            }
                            if (lst.modCount == mc) {
                                return;
                            }
                        }
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }

    final class ArrayListSpliterator
    implements Spliterator<E> {
        private int index;
        private int fence;
        private int expectedModCount;

        ArrayListSpliterator(int origin, int fence, int expectedModCount) {
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = ArrayList.this.modCount;
                hi = this.fence = ArrayList.this.size;
            }
            return hi;
        }

        public ArrayListSpliterator trySplit() {
            ArrayListSpliterator arrayListSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                arrayListSpliterator = null;
            } else {
                this.index = mid;
                ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(lo, this.index, this.expectedModCount);
                arrayListSpliterator = arrayListSpliterator2;
            }
            return arrayListSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Object e = ArrayList.this.elementData[i];
                action.accept(e);
                if (ArrayList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] a = ArrayList.this.elementData;
            if (ArrayList.this.elementData != null) {
                int i;
                int mc;
                int hi = this.fence;
                if (hi < 0) {
                    mc = ArrayList.this.modCount;
                    hi = ArrayList.this.size;
                } else {
                    mc = this.expectedModCount;
                }
                if (i >= 0 && (this.index = hi) <= a.length) {
                    for (i = this.index; i < hi; ++i) {
                        Object e = a[i];
                        action.accept(e);
                    }
                    if (ArrayList.this.modCount == mc) {
                        return;
                    }
                }
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

