/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import jdk.Profile+Annotation;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
@I
@Profile+Annotation(value=1)
public class LinkedList<@KeyForBottom E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size;
    transient Node<E> first;
    transient Node<E> last;
    private static final @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable long serialVersionUID = 876323262645176354L;

    @FromByteCode
    @FromByteCode
    public LinkedList();

    @FromByteCode
    @FromByteCode
    public @PolyRead LinkedList(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    private void linkFirst(E var1);

    void linkLast(E var1);

    void linkBefore(E var1, Node<E> var2);

    private E unlinkFirst(Node<E> var1);

    private E unlinkLast(Node<E> var1);

    E unlink(Node<E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeFirst(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeLast(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public void addFirst(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addLast(@Mutable LinkedList<E> this, E var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int size(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean add(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean remove(@Mutable LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean addAll(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean addAll(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends E> var2);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear(@Mutable LinkedList<E> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E set(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, E var2);

    @Override
    @FromByteCode
    @FromByteCode
    public void add(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, E var2);

    @Override
    @FromByteCode
    @FromByteCode
    public E remove(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    private boolean isElementIndex(int var1);

    private boolean isPositionIndex(int var1);

    private String outOfBoundsMsg(int var1);

    private void checkElementIndex(int var1);

    private void checkPositionIndex(int var1);

    Node<E> node(int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E poll(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E remove(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offer(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offerFirst(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean offerLast(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollFirst(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollLast(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public void push(@Mutable LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E pop(@Mutable LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean removeFirstOccurrence(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean removeLastOccurrence(@Mutable LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    private LinkedList<E> superClone();

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I(value="N") @org.checkerframework.checker.javari.qual.Mutable Object clone();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable Object @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, T @PolyNull @UnknownKeyFor @Initialized @org.checkerframework.checker.javari.qual.Mutable [] var1);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    @Override
    public Spliterator<E> spliterator();

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedList.this.modCount == this.expectedModCount && this.nextIndex < LinkedList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    static final class LLSpliterator<E>
    implements Spliterator<E> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        final LinkedList<E> list;
        Node<E> current;
        int est;
        int expectedModCount;
        int batch;

        LLSpliterator(LinkedList<E> list, int est, int expectedModCount) {
            this.list = list;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getEst() {
            int s = this.est;
            if (s < 0) {
                LinkedList<E> lst = this.list;
                if (lst == null) {
                    this.est = 0;
                    s = 0;
                } else {
                    this.expectedModCount = lst.modCount;
                    this.current = lst.first;
                    s = this.est = lst.size;
                }
            }
            return s;
        }

        @Override
        public long estimateSize() {
            return this.getEst();
        }

        @Override
        public Spliterator<E> trySplit() {
            Node<E> p;
            int s = this.getEst();
            if (s > 1 && (p = this.current) != null) {
                int n = this.batch + 1024;
                if (n > s) {
                    n = s;
                }
                if (n > 0x2000000) {
                    n = 0x2000000;
                }
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j++] = p.item;
                } while ((p = p.next) != null && j < n);
                this.current = p;
                this.batch = j;
                this.est = s - j;
                return Spliterators.spliterator(a, 0, j, 16);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            int n = this.getEst();
            if (n > 0 && (p = this.current) != null) {
                this.current = null;
                this.est = 0;
                do {
                    Object e = p.item;
                    p = p.next;
                    action.accept(e);
                } while (p != null && --n > 0);
            }
            if (this.list.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.getEst() > 0 && (p = this.current) != null) {
                --this.est;
                Object e = p.item;
                this.current = p.next;
                action.accept(e);
                if (this.list.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

