/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
public class LinkedList<@KeyForBottom E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size;
    transient Node<E> first;
    transient Node<E> last;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = 876323262645176354L;

    @FromByteCode
    @FromByteCode
    public LinkedList();

    @FromByteCode
    @FromByteCode
    public LinkedList(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var1);

    private void linkFirst(E var1);

    void linkLast(E var1);

    void linkBefore(E var1, Node<E> var2);

    private E unlinkFirst(Node<E> var1);

    private E unlinkLast(Node<E> var1);

    E unlink(Node<E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E getFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public E getLast();

    @Override
    @FromByteCode
    @FromByteCode
    public E removeFirst(@GuardSatisfied LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeLast(@GuardSatisfied LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public void addFirst(@GuardSatisfied LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addLast(@GuardSatisfied LinkedList<E> this, E var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean contains(@GuardSatisfied LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int size(@GuardSatisfied LinkedList<E> this);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean add(@GuardSatisfied LinkedList<E> this, E var1);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean remove(@GuardSatisfied LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean addAll(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean addAll(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var2);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public E get(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public void add(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public E remove(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    private boolean isElementIndex(int var1);

    private boolean isPositionIndex(int var1);

    private String outOfBoundsMsg(int var1);

    private void checkElementIndex(int var1);

    private void checkPositionIndex(int var1);

    Node<E> node(int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int indexOf(@GuardSatisfied LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int lastIndexOf(@GuardSatisfied LinkedList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peek();

    @Override
    @FromByteCode
    @FromByteCode
    public E element();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E poll();

    @Override
    @FromByteCode
    @FromByteCode
    public E remove(@GuardSatisfied LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offer(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offerFirst(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offerLast(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekLast();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollLast();

    @Override
    @FromByteCode
    @FromByteCode
    public void push(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E pop();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeFirstOccurrence(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeLastOccurrence(@GuardSatisfied LinkedList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy ListIterator<E> listIterator(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Iterator<E> descendingIterator();

    private LinkedList<E> superClone();

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object clone(@GuardSatisfied LinkedList<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Object @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] toArray();

    @Override
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] toArray(T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] var1);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedList.this.modCount == this.expectedModCount && this.nextIndex < LinkedList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

