/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class LogManager {
    private static @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogManager manager;
    private volatile @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Properties props;
    private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown PropertyChangeSupport changes;
    private static final @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Level defaultLevel;
    private final LoggerContext systemContext;
    private final LoggerContext userContext;
    private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger rootLogger;
    private volatile @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean readPrimordialConfiguration;
    private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean initializedGlobalHandlers;
    private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean deathImminent;
    private static WeakHashMap<Object, LoggerContext> contextsMap;
    private final @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown ReferenceQueue<@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger> loggerRefQueue;
    private static final @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown int MAX_ITERATIONS = 400;
    private final Permission controlPermission;
    private static @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LoggingMXBean loggingMXBean;
    public static final @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    @FromByteCode
    protected LogManager();

    private LogManager(Void var1);

    private static Void checkSubclassPermissions();

    @FromByteCode
    public static @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogManager getLogManager();

    @FromByteCode
    private void readPrimordialConfiguration();

    @FromByteCode
    public void addPropertyChangeListener(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown PropertyChangeListener var1) throws SecurityException;

    @FromByteCode
    public void removePropertyChangeListener(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown PropertyChangeListener var1) throws SecurityException;

    private LoggerContext getUserContext();

    private List<LoggerContext> contexts();

    Logger demandLogger(String var1, String var2, Class<?> var3);

    Logger demandSystemLogger(String var1, String var2);

    @FromByteCode
    private void loadLoggerHandlers(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var2, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var3);

    @FromByteCode
    final void drainLoggerRefQueueBounded();

    @FromByteCode
    public @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean addLogger(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var1);

    @FromByteCode
    private static void doSetLevel(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var0, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Level var1);

    @FromByteCode
    private static void doSetParent(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var0, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var1);

    @FromByteCode
    public @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger getLogger(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1);

    @FromByteCode
    public @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Enumeration<@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String> getLoggerNames();

    @FromByteCode
    public void readConfiguration() throws IOException, SecurityException;

    @FromByteCode
    public void reset() throws SecurityException;

    private void resetLogger(Logger var1);

    @FromByteCode
    private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown [] parseClassNames(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1);

    @FromByteCode
    public void readConfiguration(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown InputStream var1) throws IOException, SecurityException;

    @FromByteCode
    public @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String getProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String getStringProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var2);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown int getIntProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown int var2);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean getBooleanProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown boolean var2);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Level getLevelProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Level var2);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Filter getFilterProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Filter var2);

    @FromByteCode
    @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Formatter getFormatterProperty(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String var1, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Formatter var2);

    @FromByteCode
    private synchronized void initializeGlobalHandlers();

    void checkPermission();

    @FromByteCode
    public void checkAccess() throws SecurityException;

    @FromByteCode
    private synchronized void setLevelsOnExistingLoggers();

    @FromByteCode
    public static synchronized @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LoggingMXBean getLoggingMXBean();

    static;

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private class Cleaner
    extends Thread {
        @FromByteCode
        private Cleaner(LogManager var1);

        @Override
        @FromByteCode
        public void run();
    }

    class LoggerContext {
        private final ConcurrentHashMap<String, LoggerWeakRef> namedLoggers = new ConcurrentHashMap();
        private final LogNode root = new LogNode(null, this);

        private LoggerContext() {
        }

        final boolean requiresDefaultLoggers() {
            boolean requiresDefaultLoggers;
            boolean bl = requiresDefaultLoggers = this.getOwner() == manager;
            if (requiresDefaultLoggers) {
                this.getOwner().ensureLogManagerInitialized();
            }
            return requiresDefaultLoggers;
        }

        final LogManager getOwner() {
            return LogManager.this;
        }

        final Logger getRootLogger() {
            return this.getOwner().rootLogger;
        }

        final Logger getGlobalLogger() {
            Logger global = Logger.global;
            return global;
        }

        Logger demandLogger(String name, String resourceBundleName, Module module) {
            LogManager owner = this.getOwner();
            return owner.demandLogger(name, resourceBundleName, module);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers()) {
                this.ensureDefaultLogger(this.getRootLogger());
                this.ensureDefaultLogger(this.getGlobalLogger());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Logger findLogger(String name) {
            Logger logger;
            LoggerWeakRef ref = this.namedLoggers.get(name);
            Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
            if (logger != null || ref == null && !name.isEmpty() && !name.equals("global")) {
                return logger;
            }
            LoggerContext loggerContext = this;
            synchronized (loggerContext) {
                this.ensureInitialized();
                ref = this.namedLoggers.get(name);
                if (ref == null) {
                    return null;
                }
                logger = (Logger)ref.get();
                if (logger == null) {
                    ref.dispose();
                }
                return logger;
            }
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            String name;
            if (this.requiresDefaultLoggers() && !(name = logger.getName()).isEmpty()) {
                this.ensureDefaultLogger(this.getRootLogger());
                if (!"global".equals(name)) {
                    this.ensureDefaultLogger(this.getGlobalLogger());
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers() || logger == null || logger != this.getGlobalLogger() && logger != LogManager.this.rootLogger) {
                assert (logger == null);
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers());
        }

        synchronized boolean addLocalLogger(Logger logger, boolean addDefaultLoggersIfNeeded) {
            LoggerWeakRef nodeRef;
            String name;
            if (addDefaultLoggersIfNeeded) {
                this.ensureAllDefaultLoggers(logger);
            }
            if ((name = logger.getName()) == null) {
                throw new NullPointerException();
            }
            LoggerWeakRef ref = this.namedLoggers.get(name);
            if (ref != null) {
                if (ref.refersTo(null)) {
                    ref.dispose();
                } else {
                    return false;
                }
            }
            LogManager owner = this.getOwner();
            logger.setLogManager(owner);
            LogManager logManager = owner;
            Objects.requireNonNull(logManager);
            ref = new LoggerWeakRef(logManager, logger);
            Level level = owner.getLevelProperty(name + ".level", null);
            if (level != null && !logger.isLevelInitialized()) {
                LogManager.doSetLevel(logger, level);
            }
            this.processParentHandlers(logger, name, VisitedLoggers.NEVER);
            LogNode node = this.getNode(name);
            node.loggerRef = ref;
            Logger parent = null;
            LogNode nodep = node.parent;
            while (nodep != null && ((nodeRef = nodep.loggerRef) == null || (parent = (Logger)nodeRef.get()) == null)) {
                nodep = nodep.parent;
            }
            if (parent != null) {
                LogManager.doSetParent(logger, parent);
            }
            node.walkAndSetParent(logger);
            ref.setNode(node);
            this.namedLoggers.put(name, ref);
            return true;
        }

        void removeLoggerRef(String name, LoggerWeakRef ref) {
            this.namedLoggers.remove(name, ref);
        }

        synchronized Enumeration<String> getLoggerNames() {
            this.ensureInitialized();
            return Collections.enumeration(this.namedLoggers.keySet());
        }

        private void processParentHandlers(final Logger logger, final String name, Predicate<Logger> visited) {
            String pname;
            int ix2;
            final LogManager owner = this.getOwner();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean useParent;
                    if (logger != owner.rootLogger && !(useParent = owner.getBooleanProperty(name + ".useParentHandlers", true))) {
                        logger.setUseParentHandlers(false);
                    }
                    return null;
                }
            });
            int ix = 1;
            while ((ix2 = name.indexOf(46, ix)) >= 0 && (owner.getProperty((pname = name.substring(0, ix2)) + ".level") == null && owner.getProperty(pname + ".handlers") == null || !visited.test(this.demandLogger(pname, null, null)))) {
                ix = ix2 + 1;
            }
        }

        LogNode getNode(String name) {
            if (name == null || name.isEmpty()) {
                return this.root;
            }
            LogNode node = this.root;
            while (name.length() > 0) {
                LogNode child;
                String head;
                int ix = name.indexOf(46);
                if (ix > 0) {
                    head = name.substring(0, ix);
                    name = name.substring(ix + 1);
                } else {
                    head = name;
                    name = "";
                }
                if (node.children == null) {
                    node.children = new HashMap();
                }
                if ((child = node.children.get(head)) == null) {
                    child = new LogNode(node, this);
                    node.children.put(head, child);
                }
                node = child;
            }
            return node;
        }
    }

    final class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext(LogManager this$0) {
        }

        @Override
        Logger demandLogger(String name, String resourceBundleName, Module module) {
            Logger result = this.findLogger(name);
            if (result == null) {
                Logger newLogger = new Logger(name, resourceBundleName, module, this.getOwner(), true);
                while ((result = this.addLocalLogger(newLogger) ? newLogger : this.findLogger(name)) == null) {
                }
            }
            return result;
        }
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String name;
        private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogNode node;
        private @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown WeakReference<@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger> parentRef;
        private boolean disposed;

        @FromByteCode
        LoggerWeakRef(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogManager var1, Logger var2);

        @FromByteCode
        void dispose();

        @FromByteCode
        void setNode(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogNode var1);

        @FromByteCode
        void setParentRef(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown WeakReference<@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger> var1);
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private static class LogNode {
        @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown HashMap<@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown String, @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogNode> children;
        @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LoggerWeakRef loggerRef;
        @UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogNode parent;
        final LoggerContext context;

        LogNode(LogNode var1, LoggerContext var2);

        @FromByteCode
        void walkAndSetParent(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Logger var1);
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    private final class RootLogger
    extends Logger {
        @FromByteCode
        private RootLogger(LogManager var1);

        @Override
        @Pure
        @FromByteCode
        public void log(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown LogRecord var1);

        @Override
        @Pure
        @FromByteCode
        public void addHandler(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Handler var1);

        @Override
        @Pure
        @FromByteCode
        public void removeHandler(@UnknownVal @SearchIndexUnknown @SameLenUnknown @MinLen(value=0) @LowerBoundUnknown @UpperBoundUnknown Handler var1);

        @Override
        Handler[] accessCheckedHandlers();
    }
}

