/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
public abstract class AbstractList<@KeyForBottom E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    @FromByteCode
    @FromByteCode
    protected AbstractList();

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean add(E var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public abstract E get(@GuardSatisfied AbstractList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E set(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public void add(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, E var2);

    @Override
    @FromByteCode
    @ReleasesNoLocks
    @FromByteCode
    public E remove(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int indexOf(@GuardSatisfied AbstractList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int lastIndexOf(@GuardSatisfied AbstractList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean addAll(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var2);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Iterator<E> iterator();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy ListIterator<E> listIterator();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy ListIterator<E> listIterator(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy List<E> subList(@GuardSatisfied AbstractList<E> this, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean equals(@GuardSatisfied AbstractList<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int hashCode(@GuardSatisfied AbstractList<E> this);

    protected void removeRange(int var1, int var2);

    private void rangeCheckForAdd(int var1);

    private String outOfBoundsMsg(int var1);

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = AbstractList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException(e);
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = AbstractList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException(e);
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                AbstractList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

