/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.WeakHashMap;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
public class WeakHashMap<@KeyForBottom K, @KeyForBottom V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue;
    int modCount;
    private static final Object NULL_KEY;
    private transient Set<Map.Entry<K, V>> entrySet;

    private Entry<K, V>[] newTable(int var1);

    @FromByteCode
    @FromByteCode
    public WeakHashMap(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable float var2);

    @FromByteCode
    @FromByteCode
    public WeakHashMap(@UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int var1);

    @FromByteCode
    @FromByteCode
    public WeakHashMap();

    @FromByteCode
    @FromByteCode
    public @PolyRead WeakHashMap(@UnknownKeyFor @NonNull @Initialized @PolyRead Map<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends K, @KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends V> var1);

    private static Object maskNull(Object var0);

    static Object unmaskNull(Object var0);

    private static boolean eq(Object var0, Object var1);

    private static int indexFor(int var0, int var1);

    private void expungeStaleEntries();

    private Entry<K, V>[] getTable();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable int size(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this);

    @Override
    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @UnknownKeyFor @Initialized @ReadOnly Object var1);

    Entry<K, V> getEntry(Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable V put(@Mutable WeakHashMap<K, V> this, K var1, V var2);

    void resize(int var1);

    private void transfer(Entry<K, V>[] var1, Entry<K, V>[] var2);

    @Override
    @FromByteCode
    @FromByteCode
    public void putAll(@Mutable WeakHashMap<K, V> this, @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<@KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends K, @KeyForBottom @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable ? extends V> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable V remove(@Mutable WeakHashMap<K, V> this, @Nullable @UnknownKeyFor @Initialized @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    boolean removeMapping(Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear(@Mutable WeakHashMap<K, V> this);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @org.checkerframework.checker.javari.qual.Mutable boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @UnknownKeyFor @Initialized @ReadOnly Object var1);

    private boolean containsNullValue();

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this);

    @Override
    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @I @PolyRead Set<@UnknownKeyFor @NonNull @Initialized @I @org.checkerframework.checker.javari.qual.Mutable Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this);

    static;

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            Object k2 = e.getKey();
            return (k1 == k2 || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return Objects.hashCode(k) ^ Objects.hashCode(v);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakHashMap.this.modCount;
            this.index = WeakHashMap.this.isEmpty() ? 0 : WeakHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(WeakHashMap.this);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakHashMap.this.containsKey(o)) {
                WeakHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        public Spliterator<K> spliterator() {
            return new KeySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(WeakHashMap.this);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        public Spliterator<V> spliterator() {
            return new ValueSpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(WeakHashMap.this);
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && WeakHashMap.this.getEntry((e = (Map.Entry)o).getKey()) != null && WeakHashMap.this.getEntry(e.getKey()).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e : this) {
                list.add(new AbstractMap.SimpleEntry(e));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }

        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }
}

