/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.ResourceBundleProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.javari.qual.ThisMutable;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import sun.util.locale.BaseLocale;
import sun.util.locale.LocaleObjectCache;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public abstract class ResourceBundle {
    private static final int INITIAL_CACHE_SIZE = 32;
    private static final ResourceBundle NONEXISTENT_BUNDLE;
    private static final ConcurrentMap<CacheKey, BundleReference> cacheList;
    private static final ReferenceQueue referenceQueue;
    protected @ThisMutable ResourceBundle parent;
    private Locale locale;
    private String name;
    private volatile boolean expired;
    private volatile CacheKey cacheKey;
    private volatile Set<String> keySet;

    @FromByteCode
    @FromByteCode
    public ResourceBundle();

    @FromByteCode
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @ReadOnly String getString(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

    @FromByteCode
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @ReadOnly String @UnknownKeyFor @NonNull @Initialized @Mutable [] getStringArray(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

    @FromByteCode
    @FromByteCode
    public final @UnknownKeyFor @NonNull @Initialized @Mutable Object getObject(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable Locale getLocale(@ReadOnly ResourceBundle this);

    private static ClassLoader getLoader();

    private static native Class[] getClassContext();

    @FromByteCode
    protected void setParent(@Mutable ResourceBundle var1);

    @FromByteCode
    @FromByteCode
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0);

    @FromByteCode
    @FromByteCode
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @UnknownKeyFor @NonNull @Initialized @Mutable Control var1);

    @FromByteCode
    @FromByteCode
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var1);

    @FromByteCode
    @FromByteCode
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var1, @UnknownKeyFor @NonNull @Initialized @Mutable Control var2);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var1, @UnknownKeyFor @NonNull @Initialized @Mutable ClassLoader var2);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle getBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var1, @UnknownKeyFor @NonNull @Initialized @Mutable ClassLoader var2, @UnknownKeyFor @NonNull @Initialized @Mutable Control var3);

    private static ResourceBundle getBundleImpl(String var0, Locale var1, ClassLoader var2, Control var3);

    private static final boolean checkList(List var0);

    private static final ResourceBundle findBundle(CacheKey var0, List<Locale> var1, List<String> var2, int var3, Control var4, ResourceBundle var5);

    private static final ResourceBundle loadBundle(CacheKey var0, List<String> var1, Control var2, boolean var3);

    private static final boolean isValidBundle(ResourceBundle var0);

    private static final boolean hasValidParentChain(ResourceBundle var0);

    private static final void throwMissingResourceException(String var0, Locale var1, Throwable var2);

    private static final ResourceBundle findBundleInCache(CacheKey var0, Control var1);

    private static final ResourceBundle putBundleInCache(CacheKey var0, ResourceBundle var1, Control var2);

    private static final void setExpirationTime(CacheKey var0, Control var1);

    @FromByteCode
    @FromByteCode
    public static final void clearCache();

    @FromByteCode
    @FromByteCode
    public static final void clearCache(@UnknownKeyFor @NonNull @Initialized @Mutable ClassLoader var0);

    @FromByteCode
    protected abstract @Mutable Object handleGetObject(@ReadOnly String var1);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public abstract @UnknownKeyFor @NonNull @Initialized @Mutable Enumeration<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> getKeys();

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean containsKey(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable Set<@KeyFor(value={"this"}) @NonNull @Initialized @ReadOnly String> keySet();

    @FromByteCode
    protected @Mutable Set<@ReadOnly String> handleKeySet();

    static;

    private static final class CacheKey {
        private final String name;
        private volatile Locale locale;
        private final KeyElementReference<Module> moduleRef;
        private final KeyElementReference<Module> callerRef;
        private final int modulesHash;
        private volatile String format;
        private volatile long loadTime;
        private volatile long expirationTime;
        private volatile Throwable cause;
        private volatile ServiceLoader<ResourceBundleProvider> providers;
        private volatile boolean providersChecked;
        private volatile Boolean callerHasProvider;

        CacheKey(String baseName, Locale locale, Module module, Module caller) {
            Objects.requireNonNull(module);
            Objects.requireNonNull(caller);
            this.name = baseName;
            this.locale = locale;
            this.moduleRef = new KeyElementReference<Module>(module, referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(caller, referenceQueue, this);
            this.modulesHash = module.hashCode() ^ caller.hashCode();
        }

        CacheKey(CacheKey src) {
            this.moduleRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getModule()), referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getCallerModule()), referenceQueue, this);
            this.name = src.name;
            this.locale = src.locale;
            this.modulesHash = src.modulesHash;
            this.format = src.format;
            this.loadTime = src.loadTime;
            this.expirationTime = src.expirationTime;
        }

        String getName() {
            return this.name;
        }

        Locale getLocale() {
            return this.locale;
        }

        CacheKey setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        Module getModule() {
            return (Module)this.moduleRef.get();
        }

        Module getCallerModule() {
            return (Module)this.callerRef.get();
        }

        ServiceLoader<ResourceBundleProvider> getProviders() {
            if (!this.providersChecked) {
                this.providers = ResourceBundle.getServiceLoader((Module)this.getModule(), (String)this.name);
                this.providersChecked = true;
            }
            return this.providers;
        }

        boolean hasProviders() {
            return this.getProviders() != null;
        }

        boolean callerHasProvider() {
            return this.callerHasProvider == Boolean.TRUE;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                CacheKey otherEntry = (CacheKey)other;
                if (this.modulesHash != otherEntry.modulesHash) {
                    return false;
                }
                if (!this.name.equals(otherEntry.name)) {
                    return false;
                }
                if (!this.locale.equals(otherEntry.locale)) {
                    return false;
                }
                Module module = this.getModule();
                Module caller = this.getCallerModule();
                return module != null && module.equals(otherEntry.getModule()) && caller != null && caller.equals(otherEntry.getCallerModule());
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode() << 3 ^ this.locale.hashCode() ^ this.modulesHash;
        }

        String getFormat() {
            return this.format;
        }

        void setFormat(String format) {
            this.format = format;
        }

        private void setCause(Throwable cause) {
            if (this.cause == null) {
                this.cause = cause;
            } else if (this.cause instanceof ClassNotFoundException) {
                this.cause = cause;
            }
        }

        private Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            String l = this.locale.toString();
            if (l.isEmpty()) {
                l = !this.locale.getVariant().isEmpty() ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", locale=" + l + ", module=" + this.getModule() + ", callerModule=" + this.getCallerModule() + ", format=" + this.format + "]";
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    private static class BundleReference
    extends SoftReference<ResourceBundle>
    implements CacheKeyReference {
        private final CacheKey cacheKey;

        BundleReference(ResourceBundle referent, ReferenceQueue<Object> q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     * Exception performing whole class analysis ignored.
     */
    public static class Control {
        public static final @UnknownKeyFor @NonNull @Initialized @ThisMutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> FORMAT_DEFAULT;
        public static final @UnknownKeyFor @NonNull @Initialized @ThisMutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> FORMAT_CLASS;
        public static final @UnknownKeyFor @NonNull @Initialized @ThisMutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> FORMAT_PROPERTIES;
        public static final @UnknownKeyFor @NonNull @Initialized @Mutable long TTL_DONT_CACHE = -1L;
        public static final @UnknownKeyFor @NonNull @Initialized @Mutable long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE;
        private static final CandidateListCache CANDIDATES_CACHE;

        @FromByteCode
        @FromByteCode
        protected Control();

        @FromByteCode
        @FromByteCode
        public static final @UnknownKeyFor @NonNull @Initialized @Mutable Control getControl(@UnknownKeyFor @NonNull @Initialized @Mutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> var0);

        @FromByteCode
        @FromByteCode
        public static final @UnknownKeyFor @NonNull @Initialized @Mutable Control getNoFallbackControl(@UnknownKeyFor @NonNull @Initialized @Mutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> var0);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable List<@UnknownKeyFor @NonNull @Initialized @ReadOnly String> getFormats(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable List<@UnknownKeyFor @NonNull @Initialized @Mutable Locale> getCandidateLocales(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable Locale getFallbackLocale(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle newBundle(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var3, @UnknownKeyFor @NonNull @Initialized @Mutable ClassLoader var4, @UnknownKeyFor @NonNull @Initialized @Mutable boolean var5) throws IllegalAccessException, InstantiationException, IOException;

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable long getTimeToLive(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @Mutable boolean needsReload(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var3, @UnknownKeyFor @NonNull @Initialized @Mutable ClassLoader var4, @UnknownKeyFor @NonNull @Initialized @Mutable ResourceBundle var5, @UnknownKeyFor @NonNull @Initialized @Mutable long var6);

        @FromByteCode
        @FromByteCode
        public @UnknownKeyFor @NonNull @Initialized @ReadOnly String toBundleName(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @Mutable Locale var2);

        @FromByteCode
        @FromByteCode
        public final @UnknownKeyFor @NonNull @Initialized @ReadOnly String toResourceName(@ReadOnly Control this, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var2);

        static;

        private static class CandidateListCache
        extends LocaleObjectCache<BaseLocale, List<Locale>> {
            private CandidateListCache() {
            }

            @Override
            protected List<Locale> createObject(BaseLocale base) {
                String language = base.getLanguage();
                String script = base.getScript();
                String region = base.getRegion();
                String variant = base.getVariant();
                boolean isNorwegianBokmal = false;
                boolean isNorwegianNynorsk = false;
                if (language.equals("no")) {
                    if (region.equals("NO") && variant.equals("NY")) {
                        variant = "";
                        isNorwegianNynorsk = true;
                    } else {
                        isNorwegianBokmal = true;
                    }
                }
                if (language.equals("nb") || isNorwegianBokmal) {
                    List<Locale> tmpList = CandidateListCache.getDefaultList("nb", script, region, variant);
                    ArrayList<Locale> bokmalList = new ArrayList<Locale>();
                    for (Locale l_nb : tmpList) {
                        boolean isRoot = l_nb.getLanguage().isEmpty();
                        Locale l_no = Locale.getInstance(isRoot ? "" : "no", l_nb.getScript(), l_nb.getCountry(), l_nb.getVariant(), null);
                        bokmalList.add(isNorwegianBokmal ? l_no : l_nb);
                        if (isRoot) break;
                        bokmalList.add(isNorwegianBokmal ? l_nb : l_no);
                    }
                    return bokmalList;
                }
                if (language.equals("nn") || isNorwegianNynorsk) {
                    List<Locale> nynorskList = CandidateListCache.getDefaultList("nn", script, region, variant);
                    int idx = nynorskList.size() - 1;
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", "NY"));
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", ""));
                    nynorskList.add(idx++, Locale.getInstance("no", "", ""));
                    return nynorskList;
                }
                if (language.equals("zh") && script.isEmpty() && !region.isEmpty()) {
                    switch (region) {
                        case "TW": 
                        case "HK": 
                        case "MO": {
                            script = "Hant";
                            break;
                        }
                        case "CN": 
                        case "SG": {
                            script = "Hans";
                        }
                    }
                }
                return CandidateListCache.getDefaultList(language, script, region, variant);
            }

            private static List<Locale> getDefaultList(String language, String script, String region, String variant) {
                ArrayList<String> variants = null;
                if (!variant.isEmpty()) {
                    variants = new ArrayList<String>();
                    int idx = variant.length();
                    while (idx != -1) {
                        variants.add(variant.substring(0, idx));
                        --idx;
                        idx = variant.lastIndexOf(95, idx);
                    }
                }
                ArrayList<Locale> list = new ArrayList<Locale>();
                if (variants != null) {
                    for (String v : variants) {
                        list.add(Locale.getInstance(language, script, region, v, null));
                    }
                }
                if (!region.isEmpty()) {
                    list.add(Locale.getInstance(language, script, region, "", null));
                }
                if (!script.isEmpty()) {
                    list.add(Locale.getInstance(language, script, "", "", null));
                    if (language.equals("zh") && region.isEmpty()) {
                        switch (script) {
                            case "Hans": {
                                region = "CN";
                                break;
                            }
                            case "Hant": {
                                region = "TW";
                            }
                        }
                    }
                    if (variants != null) {
                        for (String v : variants) {
                            list.add(Locale.getInstance(language, "", region, v, null));
                        }
                    }
                    if (!region.isEmpty()) {
                        list.add(Locale.getInstance(language, "", region, "", null));
                    }
                }
                if (!language.isEmpty()) {
                    list.add(Locale.getInstance(language, "", "", "", null));
                }
                list.add(Locale.ROOT);
                return list;
            }
        }
    }

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> formats) {
            this.formats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return this.formats;
        }
    }

    private static final class NoFallbackControl
    extends SingleFormatControl {
        private static final Control NO_FALLBACK = new NoFallbackControl(FORMAT_DEFAULT);
        private static final Control PROPERTIES_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_CLASS);

        protected NoFallbackControl(List<String> formats) {
            super(formats);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

