/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerialCallbackContext;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import jdk.internal.util.ByteArray;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo;

    @FromByteCode
    public ObjectOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream var1) throws IOException;

    protected ObjectOutputStream() throws IOException, SecurityException;

    @FromByteCode
    public void useProtocolVersion(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public final void writeObject(@Nullable @UnknownKeyFor @Initialized Object var1) throws IOException;

    protected void writeObjectOverride(Object var1) throws IOException;

    @FromByteCode
    public void writeUnshared(@UnknownKeyFor @NonNull @Initialized Object var1) throws IOException;

    @FromByteCode
    public void defaultWriteObject() throws IOException;

    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized PutField putFields() throws IOException;

    @FromByteCode
    public void writeFields() throws IOException;

    @FromByteCode
    public void reset() throws IOException;

    protected void annotateClass(Class<?> var1) throws IOException;

    protected void annotateProxyClass(Class<?> var1) throws IOException;

    protected Object replaceObject(Object var1) throws IOException;

    protected boolean enableReplaceObject(boolean var1) throws SecurityException;

    protected void writeStreamHeader() throws IOException;

    protected void writeClassDescriptor(ObjectStreamClass var1) throws IOException;

    @Override
    @FromByteCode
    public void write(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1) throws IOException;

    @Override
    @FromByteCode
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized int var3) throws IOException;

    @Override
    @FromByteCode
    public void flush() throws IOException;

    protected void drain() throws IOException;

    @Override
    @FromByteCode
    public void close() throws IOException;

    @Override
    @FromByteCode
    public void writeBoolean(@UnknownKeyFor @NonNull @Initialized boolean var1) throws IOException;

    @Override
    @FromByteCode
    public void writeByte(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public void writeShort(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public void writeChar(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public void writeInt(@UnknownKeyFor @NonNull @Initialized int var1) throws IOException;

    @Override
    @FromByteCode
    public void writeLong(@UnknownKeyFor @NonNull @Initialized long var1) throws IOException;

    @Override
    @FromByteCode
    public void writeFloat(@UnknownKeyFor @NonNull @Initialized float var1) throws IOException;

    @Override
    @FromByteCode
    public void writeDouble(@UnknownKeyFor @NonNull @Initialized double var1) throws IOException;

    @Override
    @FromByteCode
    public void writeBytes(@UnknownKeyFor @NonNull @Initialized String var1) throws IOException;

    @Override
    @FromByteCode
    public void writeChars(@UnknownKeyFor @NonNull @Initialized String var1) throws IOException;

    @Override
    @FromByteCode
    public void writeUTF(@UnknownKeyFor @NonNull @Initialized String var1) throws IOException;

    int getProtocolVersion();

    void writeTypeString(String var1) throws IOException;

    private void verifySubclass();

    private static boolean auditSubclass(Class var0);

    private void clear();

    private void writeObject0(Object var1, boolean var2) throws IOException;

    private void writeNull() throws IOException;

    private void writeHandle(int var1) throws IOException;

    private void writeClass(Class var1, boolean var2) throws IOException;

    private void writeClassDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private void writeProxyDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private void writeNonProxyDesc(ObjectStreamClass var1, boolean var2) throws IOException;

    private void writeString(String var1, boolean var2) throws IOException;

    private void writeArray(Object var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeEnum(Enum var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeOrdinaryObject(Object var1, ObjectStreamClass var2, boolean var3) throws IOException;

    private void writeExternalData(Externalizable var1) throws IOException;

    private void writeSerialData(Object var1, ObjectStreamClass var2) throws IOException;

    private void defaultWriteFields(Object var1, ObjectStreamClass var2) throws IOException;

    private void writeFatalException(IOException var1) throws IOException;

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static;

    private static class Caches {
        static final ClassValue<Boolean> subclassAudits = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                return ObjectOutputStream.auditSubclass(type);
            }
        };

        private Caches() {
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     * Exception performing whole class analysis ignored.
     */
    public static abstract class PutField {
        @FromByteCode
        public PutField();

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized boolean var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized byte var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized char var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized short var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized int var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized long var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized float var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized double var2);

        @FromByteCode
        public abstract void put(@UnknownKeyFor @NonNull @Initialized String var1, @Nullable @UnknownKeyFor @Initialized Object var2);

        @Deprecated
        @FromByteCode
        public abstract void write(@UnknownKeyFor @NonNull @Initialized ObjectOutput var1) throws IOException;
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
        }

        @Override
        public void put(String name, boolean val) {
            ByteArray.setBoolean(this.primVals, this.getFieldOffset(name, Boolean.TYPE), val);
        }

        @Override
        public void put(String name, byte val) {
            this.primVals[this.getFieldOffset((String)name, Byte.TYPE)] = val;
        }

        @Override
        public void put(String name, char val) {
            ByteArray.setChar(this.primVals, this.getFieldOffset(name, Character.TYPE), val);
        }

        @Override
        public void put(String name, short val) {
            ByteArray.setShort(this.primVals, this.getFieldOffset(name, Short.TYPE), val);
        }

        @Override
        public void put(String name, int val) {
            ByteArray.setInt(this.primVals, this.getFieldOffset(name, Integer.TYPE), val);
        }

        @Override
        public void put(String name, float val) {
            ByteArray.setFloat(this.primVals, this.getFieldOffset(name, Float.TYPE), val);
        }

        @Override
        public void put(String name, long val) {
            ByteArray.setLong(this.primVals, this.getFieldOffset(name, Long.TYPE), val);
        }

        @Override
        public void put(String name, double val) {
            ByteArray.setDouble(this.primVals, this.getFieldOffset(name, Double.TYPE), val);
        }

        @Override
        public void put(String name, Object val) {
            this.objVals[this.getFieldOffset((String)name, Object.class)] = val;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (ObjectOutputStream.this != out) {
                throw new IllegalArgumentException("wrong stream");
            }
            out.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (fields[numPrimFields + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                out.writeObject(this.objVals[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (extendedDebugInfo) {
                    ObjectOutputStream.this.debugInfoStack.push("field (class \"" + this.desc.getName() + "\", name: \"" + fields[numPrimFields + i].getName() + "\", type: \"" + fields[numPrimFields + i].getType() + "\")");
                }
                try {
                    ObjectOutputStream.this.writeObject0(this.objVals[i], fields[numPrimFields + i].isUnshared());
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        ObjectOutputStream.this.debugInfoStack.pop();
                    }
                }
            }
        }

        private int getFieldOffset(String name, Class<?> type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field == null) {
                throw new IllegalArgumentException("no such field " + name + " with type " + type);
            }
            return field.getOffset();
        }
    }

    private static final class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream out) {
            this.out = out;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        @Override
        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (len >= 1024 && !copy && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(b, off, 1024);
                    off += 1024;
                    len -= 1024;
                    continue;
                }
                int wlen = Math.min(len, 1024 - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                ByteArray.setInt(this.hbuf, 1, len);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            ByteArray.setBoolean(this.buf, this.pos++, v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        @Override
        public void writeChar(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                ByteArray.setChar(this.buf, this.pos, (char)v);
                this.pos += 2;
            } else {
                this.dout.writeChar(v);
            }
        }

        @Override
        public void writeShort(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                ByteArray.setShort(this.buf, this.pos, (short)v);
                this.pos += 2;
            } else {
                this.dout.writeShort(v);
            }
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.pos + 4 <= 1024) {
                ByteArray.setInt(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeInt(v);
            }
        }

        @Override
        public void writeFloat(float v) throws IOException {
            if (this.pos + 4 <= 1024) {
                ByteArray.setFloat(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeFloat(v);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (this.pos + 8 <= 1024) {
                ByteArray.setLong(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeLong(v);
            }
        }

        @Override
        public void writeDouble(double v) throws IOException {
            if (this.pos + 8 <= 1024) {
                ByteArray.setDouble(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeDouble(v);
            }
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int n;
            int endoff = s.length();
            int cpos = 0;
            int csize = 0;
            for (int off = 0; off < endoff; off += n) {
                if (cpos >= csize) {
                    cpos = 0;
                    csize = Math.min(endoff - off, 256);
                    s.getChars(off, off + csize, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n = Math.min(csize - cpos, 1024 - this.pos);
                int stop = this.pos + n;
                while (this.pos < stop) {
                    this.buf[this.pos++] = (byte)this.cbuf[cpos++];
                }
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            int csize;
            int endoff = s.length();
            for (int off = 0; off < endoff; off += csize) {
                csize = Math.min(endoff - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, csize);
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        void writeBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int stop = Math.min(endoff, off + (1024 - this.pos));
                while (off < stop) {
                    ByteArray.setBoolean(this.buf, this.pos++, v[off++]);
                }
            }
        }

        void writeChars(char[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setChar(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(v[off++]);
            }
        }

        void writeShorts(short[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setShort(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(v[off++]);
            }
        }

        void writeInts(int[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setInt(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(v[off++]);
            }
        }

        void writeFloats(float[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setFloat(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeFloat(v[off++]);
            }
        }

        void writeLongs(long[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setLong(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(v[off++]);
            }
        }

        void writeDoubles(double[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setDouble(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeDouble(v[off++]);
            }
        }

        long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int limit = 1021;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (this.pos <= limit) {
                        if (c <= '\u007f' && c != '\u0000') {
                            this.buf[this.pos++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }
    }

    private static final class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    private static final class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new HandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this.htab.assign(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this.htab.lookup(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }

    private static final class DebugTraceInfoStack {
        private final List<String> stack = new ArrayList<String>();

        DebugTraceInfoStack() {
        }

        void clear() {
            this.stack.clear();
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void push(String entry) {
            this.stack.add("\t- " + entry);
        }

        public String toString() {
            StringJoiner sj = new StringJoiner("\n");
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                sj.add(this.stack.get(i));
            }
            return sj.toString();
        }
    }
}

