/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 */
@I
public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    transient int size;
    transient Node<E> first;
    transient Node<E> last;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList();

    public @PolyRead LinkedList(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> var1);

    private void linkFirst(E var1);

    void linkLast(E var1);

    void linkBefore(E var1, Node<E> var2);

    private E unlinkFirst(Node<E> var1);

    private E unlinkLast(Node<E> var1);

    E unlink(Node<E> var1);

    @Override
    public E getFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public E getLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public E removeFirst(@Mutable LinkedList<E> this);

    @Override
    public E removeLast(@Mutable LinkedList<E> this);

    @Override
    public void addFirst(@Mutable LinkedList<E> this, E var1);

    @Override
    public void addLast(@Mutable LinkedList<E> this, E var1);

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public boolean add(@Mutable LinkedList<E> this, E var1);

    @Override
    public boolean remove(@Mutable LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public boolean addAll(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var1);

    @Override
    public boolean addAll(@Mutable LinkedList<E> this, int var1, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var2);

    @Override
    public void clear(@Mutable LinkedList<E> this);

    @Override
    @Pure
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, int var1);

    @Override
    public E set(@Mutable LinkedList<E> this, int var1, E var2);

    @Override
    public void add(@Mutable LinkedList<E> this, int var1, E var2);

    @Override
    public E remove(@Mutable LinkedList<E> this, int var1);

    private boolean isElementIndex(int var1);

    private boolean isPositionIndex(int var1);

    private String outOfBoundsMsg(int var1);

    private void checkElementIndex(int var1);

    private void checkPositionIndex(int var1);

    Node<E> node(int var1);

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public E element(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public @Nullable E poll(@Mutable LinkedList<E> this);

    @Override
    public E remove(@Mutable LinkedList<E> this);

    @Override
    public boolean offer(@Mutable LinkedList<E> this, E var1);

    @Override
    public boolean offerFirst(@Mutable LinkedList<E> this, E var1);

    @Override
    public boolean offerLast(@Mutable LinkedList<E> this, E var1);

    @Override
    public @Nullable E peekFirst(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public @Nullable E peekLast(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public @Nullable E pollFirst(@Mutable LinkedList<E> this);

    @Override
    public @Nullable E pollLast(@Mutable LinkedList<E> this);

    @Override
    public void push(@Mutable LinkedList<E> this, E var1);

    @Override
    public E pop(@Mutable LinkedList<E> this);

    @Override
    public boolean removeFirstOccurrence(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public boolean removeLastOccurrence(@Mutable LinkedList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, int var1);

    @Override
    public @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    private LinkedList<E> superClone();

    @SideEffectFree
    public @I(value="N") Object clone();

    @Override
    public @Nullable Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this);

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly LinkedList<E> this, T @PolyNull [] var1);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedList.this.modCount == this.expectedModCount && this.nextIndex < LinkedList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Node<E> {
        E item;
        Node<E> next;
        Node<E> prev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

