/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.WeakHashMap;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    public WeakHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.table = this.newTable(n2);
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = this.newTable(16);
    }

    public @PolyRead WeakHashMap(@PolyRead Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n = WeakHashMap.indexFor(entry2.hash, this.table.length);
                Entry<K, V> entry3 = entry = this.table[n];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry2) {
                        if (entry == entry2) {
                            this.table[n] = entry4;
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this) {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this) {
        return this.size() == 0;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && WeakHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    @Pure
    public boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @ReadOnly Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (!(entry == null || entry.hash == n && WeakHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public @Nullable V put(@Mutable WeakHashMap<K, V> this, K k, V v) {
        Object object = WeakHashMap.maskNull(k);
        int n = HashMap.hash(object.hashCode());
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.hash && WeakHashMap.eq(object, entry.get())) {
                Object v2 = entry.value;
                if (v != v2) {
                    entry.value = v;
                }
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(object, v, this.queue, n, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n) {
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] entryArray2 = this.newTable(n);
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry<K, V> entry = entryArray[i];
            entryArray[i] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t = entry.get();
                if (t == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n = WeakHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n];
                    entryArray2[n] = entry;
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(@Mutable WeakHashMap<K, V> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public @Nullable V remove(@Mutable WeakHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry<K, V> entry;
        Object object2 = WeakHashMap.maskNull(object);
        int n = HashMap.hash(object2.hashCode());
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n == entry2.hash && WeakHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakHashMap.maskNull(entry2.getKey());
        int n = HashMap.hash(object2.hashCode());
        int n2 = WeakHashMap.indexFor(n, entryArray.length);
        Entry<K, V> entry3 = entry = entryArray[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    @Override
    public void clear(@Mutable WeakHashMap<K, V> this) {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this, @Nullable @ReadOnly Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.getTable();
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<K, V> entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this) {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet(this, null));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this) {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values(this, null));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@I Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly WeakHashMap<K, V> this) {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this, null));
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            Object k2 = e.getKey();
            return (k1 == k2 || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return Objects.hashCode(k) ^ Objects.hashCode(v);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(WeakHashMap.this);
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && WeakHashMap.this.getEntry((e = (Map.Entry)o).getKey()) != null && WeakHashMap.this.getEntry(e.getKey()).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return WeakHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            for (Map.Entry e : this) {
                list.add(new AbstractMap.SimpleEntry(e));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }

        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakHashMap.this.modCount;
            this.index = WeakHashMap.this.isEmpty() ? 0 : WeakHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t = WeakHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(WeakHashMap.this);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (WeakHashMap.this.containsKey(o)) {
                WeakHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        public Spliterator<K> spliterator() {
            return new KeySpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }

    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator(WeakHashMap weakHashMap) {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(WeakHashMap.this);
        }

        @Override
        public int size() {
            return WeakHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            WeakHashMap.this.clear();
        }

        public Spliterator<V> spliterator() {
            return new ValueSpliterator(WeakHashMap.this, 0, -1, 0, 0);
        }
    }
}

