/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Observer;
import java.util.Vector;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.igj.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;

@I
public class Observable {
    private boolean changed = false;
    private Vector obs = new Vector();

    public synchronized void addObserver(@Mutable Observable this, @Mutable Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(observer)) {
            this.obs.addElement(observer);
        }
    }

    public synchronized void deleteObserver(@Mutable Observable this, @Nullable @ReadOnly Observer observer) {
        this.obs.removeElement(observer);
    }

    public void notifyObservers(@ReadOnly Observable this) {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(@ReadOnly Observable this, @Nullable @ReadOnly Object object) {
        Object[] objectArray;
        Observable observable = this;
        synchronized (observable) {
            if (!this.changed) {
                return;
            }
            objectArray = this.obs.toArray();
            this.clearChanged();
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((Observer)objectArray[i]).update(this, object);
        }
    }

    public synchronized void deleteObservers(@Mutable Observable this) {
        this.obs.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged(@ReadOnly Observable this) {
        return this.changed;
    }

    public synchronized int countObservers(@ReadOnly Observable this) {
        return this.obs.size();
    }
}

