/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient Object[] elementData;
    private int size;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(@org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    public void trimToSize(@AssignsFields ArrayList<E> this) {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(@AssignsFields ArrayList<E> this, int n) {
        if (n > 0) {
            this.ensureCapacityInternal(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        ++this.modCount;
        if (n - this.elementData.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.elementData.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = ArrayList.hugeCapacity(n);
        }
        this.elementData = Arrays.copyOf(this.elementData, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this) {
        return this.size;
    }

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this) {
        return this.size == 0;
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    @Pure
    public int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @SideEffectFree
    public @I(value="N") Object clone(@ReadOnly ArrayList<E> this) {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public @Nullable @ReadOnly Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this) {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, T @PolyNull [] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    E elementData(int n) {
        return (E)this.elementData[n];
    }

    @Override
    @Pure
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly ArrayList<E> this, int n) {
        this.rangeCheck(n);
        return this.elementData(n);
    }

    @Override
    public E set(@Mutable ArrayList<E> this, int n, E e) {
        this.rangeCheck(n);
        E e2 = this.elementData(n);
        this.elementData[n] = e;
        return e2;
    }

    @Override
    public boolean add(@Mutable ArrayList<E> this, E e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(@Mutable ArrayList<E> this, int n, E e) {
        this.rangeCheckForAdd(n);
        this.ensureCapacityInternal(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(@Mutable ArrayList<E> this, int n) {
        this.rangeCheck(n);
        ++this.modCount;
        E e = this.elementData(n);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return e;
    }

    @Override
    public boolean remove(@Mutable ArrayList<E> this, @Nullable @ReadOnly Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear(@Mutable ArrayList<E> this) {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(@Mutable ArrayList<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacityInternal(this.size + n);
        System.arraycopy(objectArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(@Mutable ArrayList<E> this, int n, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        this.rangeCheckForAdd(n);
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacityInternal(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    private void rangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private void rangeCheckForAdd(int n) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    private String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.batchRemove(collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.batchRemove(collection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        boolean bl2;
        int n;
        block8: {
            int n2;
            Object[] objectArray = this.elementData;
            n = 0;
            bl2 = false;
            try {
                for (n2 = 0; n2 < this.size; ++n2) {
                    if (collection.contains(objectArray[n2]) != bl) continue;
                    objectArray[n++] = objectArray[n2];
                }
                if (n2 == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (n2 != this.size) {
                    System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
                    n += this.size - n2;
                }
                if (n != this.size) {
                    for (int i = n; i < this.size; ++i) {
                        objectArray[i] = null;
                    }
                    this.modCount += this.size - n;
                    this.size = n;
                    bl2 = true;
                }
                throw throwable;
            }
            System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
            n += this.size - n2;
        }
        if (n != this.size) {
            for (int i = n; i < this.size; ++i) {
                objectArray[i] = null;
            }
            this.modCount += this.size - n;
            this.size = n;
            bl2 = true;
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new Object[n];
        Object[] objectArray = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this, null);
    }

    @Override
    public List<E> subList(int n, int n2) {
        ArrayList.subListRangeCheck(n, n2, this.size);
        return new SubList(this, (AbstractList)this, 0, n, n2);
    }

    static void subListRangeCheck(int n, int n2, int n3) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
    }

    static /* synthetic */ int access$100(ArrayList arrayList) {
        return arrayList.size;
    }

    static /* synthetic */ Object[] access$200(ArrayList arrayList) {
        return arrayList.elementData;
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            int size = ArrayList.this.size;
            if (i < size) {
                Object[] es = ArrayList.this.elementData;
                if (i >= es.length) {
                    throw new ConcurrentModificationException();
                }
                for (i = this.cursor; i < size && ArrayList.this.modCount == this.expectedModCount; ++i) {
                    action.accept(ArrayList.elementAt((Object[])es, (int)i));
                }
                this.cursor = i;
                this.lastRet = i - 1;
                this.checkForComodification();
            }
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class SubList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final ArrayList<E> root;
        private final SubList<E> parent;
        private final int offset;
        private int size;

        public SubList(ArrayList<E> root, int fromIndex, int toIndex) {
            this.root = root;
            this.parent = null;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = root.modCount;
        }

        private SubList(SubList<E> parent, int fromIndex, int toIndex) {
            this.root = parent.root;
            this.parent = parent;
            this.offset = parent.offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = parent.modCount;
        }

        @Override
        public E set(int index, E element) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E oldValue = this.root.elementData(this.offset + index);
            this.root.elementData[this.offset + index] = element;
            return oldValue;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            return this.root.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E element) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.root.add(this.offset + index, element);
            this.updateSizeAndModCount(1);
        }

        @Override
        public E remove(int index) {
            Objects.checkIndex((int)index, (int)this.size);
            this.checkForComodification();
            E result = this.root.remove(this.offset + index);
            this.updateSizeAndModCount(-1);
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.root.removeRange(this.offset + fromIndex, this.offset + toIndex);
            this.updateSizeAndModCount(fromIndex - toIndex);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.root.addAll(this.offset + index, c);
            this.updateSizeAndModCount(cSize);
            return true;
        }

        public void replaceAll(UnaryOperator<E> operator) {
            this.root.replaceAllRange(operator, this.offset, this.offset + this.size);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.batchRemove(c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.batchRemove(c, true);
        }

        private boolean batchRemove(Collection<?> c, boolean complement) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.batchRemove(c, complement, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        public boolean removeIf(Predicate<? super E> filter) {
            this.checkForComodification();
            int oldSize = this.root.size;
            boolean modified = this.root.removeIf(filter, this.offset, this.offset + this.size);
            if (modified) {
                this.updateSizeAndModCount(this.root.size - oldSize);
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkForComodification();
            if (a.length < this.size) {
                return Arrays.copyOfRange(this.root.elementData, this.offset, this.offset + this.size, a.getClass());
            }
            System.arraycopy(this.root.elementData, this.offset, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            boolean equal = this.root.equalsRange((List)o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return equal;
        }

        @Override
        public int hashCode() {
            int hash = this.root.hashCodeRange(this.offset, this.offset + this.size);
            this.checkForComodification();
            return hash;
        }

        @Override
        public int indexOf(Object o) {
            int index = this.root.indexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = this.root.lastIndexOfRange(o, this.offset, this.offset + this.size);
            this.checkForComodification();
            return index >= 0 ? index - this.offset : -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = root.elementData;
                    if (offset + i >= elementData.length) {
                        throw new ConcurrentModificationException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[offset + this.lastRet];
                }

                public void forEachRemaining(Consumer<? super E> action) {
                    int i;
                    Objects.requireNonNull(action);
                    int size = size;
                    if (i < size) {
                        Object[] es = root.elementData;
                        if (offset + i >= es.length) {
                            throw new ConcurrentModificationException();
                        }
                        for (i = this.cursor; i < size && root.modCount == this.expectedModCount; ++i) {
                            action.accept(ArrayList.elementAt((Object[])es, (int)(offset + i)));
                        }
                        this.cursor = i;
                        this.lastRet = i - 1;
                        this.checkForComodification();
                    }
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        root.set(offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new ConcurrentModificationException();
                    }
                }

                final void checkForComodification() {
                    if (root.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            SubList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size);
            return new SubList<E>(this, fromIndex, toIndex);
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (this.root.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void updateSizeAndModCount(int sizeChange) {
            SubList<E> slist = this;
            do {
                slist.size += sizeChange;
                slist.modCount = this.root.modCount;
            } while ((slist = slist.parent) != null);
        }

        public Spliterator<E> spliterator() {
            this.checkForComodification();
            return new Spliterator<E>(){
                private int index;
                private int fence;
                private int expectedModCount;
                {
                    this.index = offset;
                    this.fence = -1;
                }

                private int getFence() {
                    int hi = this.fence;
                    if (hi < 0) {
                        this.expectedModCount = modCount;
                        hi = this.fence = offset + size;
                    }
                    return hi;
                }

                public ArrayListSpliterator trySplit() {
                    ArrayListSpliterator arrayListSpliterator;
                    int lo = this.index;
                    int hi = this.getFence();
                    int mid = lo + hi >>> 1;
                    if (lo >= mid) {
                        arrayListSpliterator = null;
                    } else {
                        ArrayList arrayList = root;
                        Objects.requireNonNull(arrayList);
                        this.index = mid;
                        ArrayListSpliterator arrayListSpliterator2 = new ArrayListSpliterator(arrayList, lo, this.index, this.expectedModCount);
                        arrayListSpliterator = arrayListSpliterator2;
                    }
                    return arrayListSpliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    int hi = this.getFence();
                    int i = this.index;
                    if (i < hi) {
                        this.index = i + 1;
                        Object e = root.elementData[i];
                        action.accept(e);
                        if (root.modCount != this.expectedModCount) {
                            throw new ConcurrentModificationException();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    Objects.requireNonNull(action);
                    ArrayList lst = root;
                    Object[] a = lst.elementData;
                    if (lst.elementData != null) {
                        int i;
                        int mc;
                        int hi = this.fence;
                        if (hi < 0) {
                            mc = modCount;
                            hi = offset + size;
                        } else {
                            mc = this.expectedModCount;
                        }
                        if (i >= 0 && (this.index = hi) <= a.length) {
                            for (i = this.index; i < hi; ++i) {
                                Object e = a[i];
                                action.accept(e);
                            }
                            if (lst.modCount == mc) {
                                return;
                            }
                        }
                    }
                    throw new ConcurrentModificationException();
                }

                @Override
                public long estimateSize() {
                    return this.getFence() - this.index;
                }

                @Override
                public int characteristics() {
                    return 16464;
                }
            };
        }
    }
}

